/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.proxy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public final class NativeHandle
implements AutoCloseable {
    public static final long INVALID_NATIVE_HANDLE = 0L;
    private final long nativeHandle;
    private boolean isValid;

    public NativeHandle(long nativeHandle) {
        Preconditions.checkState((nativeHandle != 0L ? 1 : 0) != 0, (String)"This handle is not valid: %s", (long)nativeHandle);
        this.nativeHandle = nativeHandle;
        this.isValid = true;
    }

    public long get() {
        this.checkValid();
        return this.nativeHandle;
    }

    @Override
    public void close() {
        if (this.isValid()) {
            this.invalidate();
        }
    }

    private void checkValid() {
        Preconditions.checkState((boolean)this.isValid, (String)"This handle is not valid: %s", (Object)this);
    }

    final boolean isValid() {
        return this.isValid;
    }

    private void invalidate() {
        this.isValid = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pointer", (Object)Long.toHexString(this.nativeHandle).toUpperCase()).toString();
    }
}

