/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.blockchain.serialization;

import com.exonum.binding.blockchain.TransactionResult;
import com.exonum.binding.blockchain.serialization.CoreProtos;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;

public enum TransactionResultSerializer implements Serializer<TransactionResult>
{
    INSTANCE;

    private static final Serializer<CoreProtos.TransactionResult> PROTO_SERIALIZER;

    public byte[] toBytes(TransactionResult value) {
        int status = this.convertToCoreStatusCode(value);
        CoreProtos.TransactionResult txLocation = CoreProtos.TransactionResult.newBuilder().setStatus(status).setDescription(value.getErrorDescription()).build();
        return txLocation.toByteArray();
    }

    public TransactionResult fromBytes(byte[] binaryTransactionResult) {
        CoreProtos.TransactionResult copiedtxLocationProtos = (CoreProtos.TransactionResult)PROTO_SERIALIZER.fromBytes(binaryTransactionResult);
        int status = copiedtxLocationProtos.getStatus();
        String description = copiedtxLocationProtos.getDescription();
        if (status <= 255) {
            return TransactionResult.error(status, description);
        }
        if (status == 256) {
            return TransactionResult.successful();
        }
        if (status == 257) {
            return TransactionResult.unexpectedError(description);
        }
        String message = String.format("Invalid status code: %s, must be in the range [0, 257]", status);
        throw new IllegalArgumentException(message);
    }

    private int convertToCoreStatusCode(TransactionResult transactionResult) {
        switch (transactionResult.getType()) {
            case ERROR: {
                return transactionResult.getErrorCode().getAsInt();
            }
            case SUCCESS: {
                return 256;
            }
            case UNEXPECTED_ERROR: {
                return 257;
            }
        }
        throw new AssertionError((Object)("Unreachable: " + transactionResult));
    }

    static {
        PROTO_SERIALIZER = StandardSerializers.protobuf(CoreProtos.TransactionResult.class);
    }
}

