/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.blockchain;

import com.exonum.binding.blockchain.AutoValue_TransactionResult;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import java.util.OptionalInt;
import javax.annotation.Nullable;

@AutoValue
public abstract class TransactionResult {
    public static final int MAX_USER_DEFINED_ERROR_CODE = 255;
    public static final int SUCCESSFUL_RESULT_STATUS_CODE = 256;
    public static final int UNEXPECTED_ERROR_STATUS_CODE = 257;
    private static final TransactionResult SUCCESSFUL_RESULT = TransactionResult.valueOf(Type.SUCCESS, null, null);

    public static TransactionResult successful() {
        return SUCCESSFUL_RESULT;
    }

    public static TransactionResult error(int errorCode, @Nullable String errorDescription) {
        Preconditions.checkArgument((0 <= errorCode && errorCode <= 255 ? 1 : 0) != 0, (String)"Error code must be in range [0; 255], but was %s", (int)errorCode);
        return TransactionResult.valueOf(Type.ERROR, errorCode, errorDescription);
    }

    public static TransactionResult unexpectedError(@Nullable String errorDescription) {
        return TransactionResult.valueOf(Type.UNEXPECTED_ERROR, null, errorDescription);
    }

    private static TransactionResult valueOf(Type type, @Nullable Integer errorCode, @Nullable String errorDescription) {
        return new AutoValue_TransactionResult(type, errorCode == null ? OptionalInt.empty() : OptionalInt.of(errorCode), Strings.nullToEmpty((String)errorDescription));
    }

    public abstract Type getType();

    public abstract OptionalInt getErrorCode();

    public abstract String getErrorDescription();

    public boolean isSuccessful() {
        return this.getType() == Type.SUCCESS;
    }

    public static TypeAdapter<TransactionResult> typeAdapter(Gson gson) {
        return new AutoValue_TransactionResult.GsonTypeAdapter(gson);
    }

    public static enum Type {
        SUCCESS,
        ERROR,
        UNEXPECTED_ERROR;

    }
}

