package com.exonum.binding.blockchain.serialization;

import com.exonum.binding.blockchain.Block;
import com.exonum.binding.blockchain.TransactionLocation;
import com.exonum.binding.blockchain.TransactionResult;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.Override;
import java.lang.SuppressWarnings;

public final class AutoValueGson_TransactionResultAdapterFactory extends TransactionResultAdapterFactory {
  @Override
  @SuppressWarnings("unchecked")
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    Class<?> rawType = type.getRawType();
    if (Block.class.isAssignableFrom(rawType)) {
      return (TypeAdapter<T>) Block.typeAdapter(gson);
    } else if (TransactionLocation.class.isAssignableFrom(rawType)) {
      return (TypeAdapter<T>) TransactionLocation.typeAdapter(gson);
    } else if (TransactionResult.class.isAssignableFrom(rawType)) {
      return (TypeAdapter<T>) TransactionResult.typeAdapter(gson);
    } else {
      return null;
    }
  }
}
