/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.util;

import com.exonum.binding.util.OsInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LibraryLoader {
    private static final String BINDING_LIB_NAME = "java_bindings";
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    private static final String DYNAMIC_LIBRARIES_ENV_VAR_WINDOWS = "PATH";
    private static final String DYNAMIC_LIBRARIES_ENV_VAR_UNIX = "LD_LIBRARY_PATH";
    private static final Logger logger = LogManager.getLogger(LibraryLoader.class);

    public static void load() {
        LibraryLoader.loadOnce();
    }

    private static void loadOnce() {
        try {
            System.loadLibrary(BINDING_LIB_NAME);
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Failed to load '{}' library: {}\u2026\n{}", (Object)BINDING_LIB_NAME, (Object)e, (Object)LibraryLoader.extraLibLoadErrorInfo());
            throw e;
        }
    }

    private static String extraLibLoadErrorInfo() {
        String javaLibPath = System.getProperty(JAVA_LIBRARY_PATH_PROPERTY);
        String dynamicLibVar = LibraryLoader.dynamicLibrariesEnvVar();
        String dynamicLibPath = System.getenv(dynamicLibVar);
        return "java.library.path=" + javaLibPath + ", \n" + dynamicLibVar + "=" + dynamicLibPath + "\nMake sure that:\n1. The path to a directory containing '" + BINDING_LIB_NAME + "' dynamic library image is included in either java.library.path system property or " + dynamicLibVar + " environment variable.\n2. The paths to directories containing dynamic libraries required by '" + BINDING_LIB_NAME + "', if any, are included in " + dynamicLibVar + " environment variable";
    }

    private static String dynamicLibrariesEnvVar() {
        if (OsInfo.isWindows()) {
            return DYNAMIC_LIBRARIES_ENV_VAR_WINDOWS;
        }
        return DYNAMIC_LIBRARIES_ENV_VAR_UNIX;
    }

    private LibraryLoader() {
    }
}

