/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;

final class StoragePreconditions {
    static final int PROOF_MAP_KEY_SIZE = 32;

    @CanIgnoreReturnValue
    static String checkIndexName(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        return name;
    }

    @CanIgnoreReturnValue
    static byte[] checkIdInGroup(byte[] indexId) {
        Preconditions.checkArgument((indexId.length > 0 ? 1 : 0) != 0, (Object)"index identifier must not be empty");
        return indexId;
    }

    @CanIgnoreReturnValue
    static byte[] checkStorageKey(byte[] key) {
        return (byte[])Preconditions.checkNotNull((Object)key, (Object)"Storage key is null");
    }

    @CanIgnoreReturnValue
    static byte[] checkProofKey(byte[] key) {
        Preconditions.checkNotNull((Object)key, (Object)"Proof map key is null");
        Preconditions.checkArgument((key.length == 32 ? 1 : 0) != 0, (String)"Proof map key has invalid size (%s), must be 32 bytes", (int)key.length);
        return key;
    }

    @CanIgnoreReturnValue
    static byte[] checkStorageValue(byte[] value) {
        return (byte[])Preconditions.checkNotNull((Object)value, (Object)"Storage value is null");
    }

    static <E> void checkNoNulls(Collection<E> collection) {
        Preconditions.checkNotNull(collection, (Object)"Collection is null");
        if (collection.contains(null)) {
            throw new NullPointerException("Collection contains nulls");
        }
    }

    @CanIgnoreReturnValue
    static long checkElementIndex(long index, long size) {
        if (index < 0L || size <= index) {
            throw new IndexOutOfBoundsException("Index must be in range [0, " + size + "), but: " + index);
        }
        return index;
    }

    @CanIgnoreReturnValue
    static long checkPositionIndex(long index, long size) {
        if (index < 0L || index > size) {
            throw new IndexOutOfBoundsException(StoragePreconditions.badPositionIndex(index, size));
        }
        return index;
    }

    private static String badPositionIndex(long index, long size) {
        if (index < 0L) {
            return "index (" + index + ") is negative";
        }
        if (size >= 0L) {
            return "index (" + index + ") is greater than size (" + size + ")";
        }
        throw new IllegalArgumentException("size (" + size + ") is negative");
    }

    private StoragePreconditions() {
    }
}

