/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.proofs.map.UncheckedMapProof;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.AbstractIndexProxy;
import com.exonum.binding.storage.indices.MapEntry;
import com.exonum.binding.storage.indices.MapEntryInternal;
import com.exonum.binding.storage.indices.MapIndex;
import com.exonum.binding.storage.indices.ProofMapKeyCheckingSerializerDecorator;
import com.exonum.binding.storage.indices.StorageIterators;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;

public final class ProofMapIndexProxy<K, V>
extends AbstractIndexProxy
implements MapIndex<K, V> {
    private final ProofMapKeyCheckingSerializerDecorator<K> keySerializer;
    private final CheckingSerializerDecorator<V> valueSerializer;

    public static <K, V> ProofMapIndexProxy<K, V> newInstance(String name, View view, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        StoragePreconditions.checkIndexName(name);
        ProofMapKeyCheckingSerializerDecorator<K> ks = ProofMapKeyCheckingSerializerDecorator.from(keySerializer);
        CheckingSerializerDecorator vs = CheckingSerializerDecorator.from(valueSerializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle mapNativeHandle = ProofMapIndexProxy.createNativeMap(view, () -> ProofMapIndexProxy.nativeCreate(name, viewNativeHandle));
        return new ProofMapIndexProxy<K, V>(mapNativeHandle, name, view, ks, vs);
    }

    public static <K, V> ProofMapIndexProxy<K, V> newInGroupUnsafe(String groupName, byte[] mapId, View view, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        StoragePreconditions.checkIndexName(groupName);
        StoragePreconditions.checkIdInGroup(mapId);
        ProofMapKeyCheckingSerializerDecorator<K> ks = ProofMapKeyCheckingSerializerDecorator.from(keySerializer);
        CheckingSerializerDecorator vs = CheckingSerializerDecorator.from(valueSerializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle mapNativeHandle = ProofMapIndexProxy.createNativeMap(view, () -> ProofMapIndexProxy.nativeCreateInGroup(groupName, mapId, viewNativeHandle));
        return new ProofMapIndexProxy<K, V>(mapNativeHandle, groupName, view, ks, vs);
    }

    private static NativeHandle createNativeMap(View view, LongSupplier nativeMapConstructor) {
        NativeHandle mapNativeHandle = new NativeHandle(nativeMapConstructor.getAsLong());
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, mapNativeHandle, ProofMapIndexProxy.class, ProofMapIndexProxy::nativeFree);
        return mapNativeHandle;
    }

    private static native long nativeCreate(String var0, long var1);

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private ProofMapIndexProxy(NativeHandle nativeHandle, String name, View view, ProofMapKeyCheckingSerializerDecorator<K> keySerializer, CheckingSerializerDecorator<V> valueSerializer) {
        super(nativeHandle, name, view);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public boolean containsKey(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        return this.nativeContainsKey(this.getNativeHandle(), dbKey);
    }

    private native boolean nativeContainsKey(long var1, byte[] var3);

    @Override
    public void put(K key, V value) {
        this.notifyModified();
        long nativeHandle = this.getNativeHandle();
        this.putInternal(nativeHandle, key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> sourceMap) {
        this.notifyModified();
        long nativeHandle = this.getNativeHandle();
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            this.putInternal(nativeHandle, entry.getKey(), entry.getValue());
        }
    }

    private void putInternal(long nativeHandle, K key, V value) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.valueSerializer.toBytes(value);
        this.nativePut(nativeHandle, dbKey, dbValue);
    }

    private native void nativePut(long var1, byte[] var3, byte[] var4);

    @Override
    public V get(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.nativeGet(this.getNativeHandle(), dbKey);
        return (V)(dbValue == null ? null : this.valueSerializer.fromBytes(dbValue));
    }

    private native byte[] nativeGet(long var1, byte[] var3);

    public UncheckedMapProof getProof(K key, K ... otherKeys) {
        if (otherKeys.length == 0) {
            return this.getSingleKeyProof(key);
        }
        List keys = Lists.asList(key, (Object[])otherKeys);
        return this.getMultiKeyProof(keys);
    }

    public UncheckedMapProof getProof(Collection<? extends K> keys) {
        Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (Object)"Keys collection should not be empty");
        if (keys.size() == 1) {
            K key = keys.iterator().next();
            return this.getSingleKeyProof(key);
        }
        return this.getMultiKeyProof(keys);
    }

    private UncheckedMapProof getSingleKeyProof(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        return this.nativeGetProof(this.getNativeHandle(), dbKey);
    }

    private native UncheckedMapProof nativeGetProof(long var1, byte[] var3);

    private UncheckedMapProof getMultiKeyProof(Collection<? extends K> keys) {
        return this.nativeGetMultiProof(this.getNativeHandle(), this.mergeKeysIntoByteArray(keys));
    }

    private byte[] mergeKeysIntoByteArray(Collection<? extends K> keys) {
        int arraySize = keys.size() * 32;
        ByteBuffer flattenedKeys = ByteBuffer.allocate(arraySize);
        keys.stream().map(this.keySerializer::toBytes).forEach(flattenedKeys::put);
        return flattenedKeys.array();
    }

    private native UncheckedMapProof nativeGetMultiProof(long var1, byte[] var3);

    public HashCode getRootHash() {
        return HashCode.fromBytes((byte[])this.nativeGetRootHash(this.getNativeHandle()));
    }

    private native byte[] nativeGetRootHash(long var1);

    @Override
    public void remove(K key) {
        this.notifyModified();
        byte[] dbKey = this.keySerializer.toBytes(key);
        this.nativeRemove(this.getNativeHandle(), dbKey);
    }

    private native void nativeRemove(long var1, byte[] var3);

    @Override
    public Iterator<K> keys() {
        return StorageIterators.createIterator(this.nativeCreateKeysIter(this.getNativeHandle()), this::nativeKeysIterNext, this::nativeKeysIterFree, this.dbView, this.modCounter, this.keySerializer::fromBytes);
    }

    private native long nativeCreateKeysIter(long var1);

    private native byte[] nativeKeysIterNext(long var1);

    private native void nativeKeysIterFree(long var1);

    @Override
    public Iterator<V> values() {
        return StorageIterators.createIterator(this.nativeCreateValuesIter(this.getNativeHandle()), this::nativeValuesIterNext, this::nativeValuesIterFree, this.dbView, this.modCounter, arg_0 -> this.valueSerializer.fromBytes(arg_0));
    }

    private native long nativeCreateValuesIter(long var1);

    private native byte[] nativeValuesIterNext(long var1);

    private native void nativeValuesIterFree(long var1);

    @Override
    public Iterator<MapEntry<K, V>> entries() {
        return StorageIterators.createIterator(this.nativeCreateEntriesIter(this.getNativeHandle()), this::nativeEntriesIterNext, this::nativeEntriesIterFree, this.dbView, this.modCounter, entry -> MapEntry.fromInternal(entry, this.keySerializer, this.valueSerializer));
    }

    private native long nativeCreateEntriesIter(long var1);

    private native MapEntryInternal nativeEntriesIterNext(long var1);

    private native void nativeEntriesIterFree(long var1);

    @Override
    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    private native void nativeClear(long var1);

    private static native void nativeFree(long var0);
}

