/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.AbstractIndexProxy;
import com.exonum.binding.storage.indices.StorageIterators;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.google.protobuf.MessageLite;
import java.util.Iterator;
import java.util.function.LongSupplier;

public final class KeySetIndexProxy<E>
extends AbstractIndexProxy
implements Iterable<E> {
    private final CheckingSerializerDecorator<E> serializer;

    public static <E extends MessageLite> KeySetIndexProxy<E> newInstance(String name, View view, Class<E> keyType) {
        return KeySetIndexProxy.newInstance(name, view, StandardSerializers.protobuf(keyType));
    }

    public static <E> KeySetIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(name);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle setNativeHandle = KeySetIndexProxy.createNativeSet(view, () -> KeySetIndexProxy.nativeCreate(name, viewNativeHandle));
        return new KeySetIndexProxy<E>(setNativeHandle, name, view, s);
    }

    public static <E> KeySetIndexProxy<E> newInGroupUnsafe(String groupName, byte[] indexId, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(groupName);
        StoragePreconditions.checkIdInGroup(indexId);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle setNativeHandle = KeySetIndexProxy.createNativeSet(view, () -> KeySetIndexProxy.nativeCreateInGroup(groupName, indexId, viewNativeHandle));
        return new KeySetIndexProxy<E>(setNativeHandle, groupName, view, s);
    }

    private static NativeHandle createNativeSet(View view, LongSupplier nativeSetConstructor) {
        Cleaner cleaner = view.getCleaner();
        NativeHandle setNativeHandle = new NativeHandle(nativeSetConstructor.getAsLong());
        ProxyDestructor.newRegistered(cleaner, setNativeHandle, KeySetIndexProxy.class, KeySetIndexProxy::nativeFree);
        return setNativeHandle;
    }

    private KeySetIndexProxy(NativeHandle nativeHandle, String name, View view, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, name, view);
        this.serializer = serializer;
    }

    public void add(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeAdd(this.getNativeHandle(), dbElement);
    }

    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    public boolean contains(E e) {
        byte[] dbElement = this.serializer.toBytes(e);
        return this.nativeContains(this.getNativeHandle(), dbElement);
    }

    @Override
    public Iterator<E> iterator() {
        return StorageIterators.createIterator(this.nativeCreateIterator(this.getNativeHandle()), this::nativeIteratorNext, this::nativeIteratorFree, this.dbView, this.modCounter, arg_0 -> this.serializer.fromBytes(arg_0));
    }

    public void remove(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeRemove(this.getNativeHandle(), dbElement);
    }

    private static native long nativeCreate(String var0, long var1);

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private native void nativeAdd(long var1, byte[] var3);

    private native void nativeClear(long var1);

    private native boolean nativeContains(long var1, byte[] var3);

    private native long nativeCreateIterator(long var1);

    private native byte[] nativeIteratorNext(long var1);

    private native void nativeIteratorFree(long var1);

    private native void nativeRemove(long var1, byte[] var3);

    private static native void nativeFree(long var0);
}

