/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.database;

import com.exonum.binding.storage.database.Fork;
import com.exonum.binding.storage.database.Snapshot;
import com.exonum.binding.storage.database.View;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ViewModificationCounter {
    static final int INITIAL_COUNT = 0;
    private static final ViewModificationCounter instance = new ViewModificationCounter();
    private final ConcurrentMap<Fork, Integer> modificationCounters = new ConcurrentHashMap<Fork, Integer>();

    ViewModificationCounter() {
    }

    public static ViewModificationCounter getInstance() {
        return instance;
    }

    void remove(Fork fork) {
        this.modificationCounters.remove(fork);
    }

    public void notifyModified(Fork fork) {
        Integer nextCount = this.getModificationCount(fork) + 1;
        this.modificationCounters.put(fork, nextCount);
    }

    public boolean isModifiedSince(View view, Integer modCount) {
        if (view instanceof Snapshot) {
            return false;
        }
        Integer currentModCount = this.getModificationCount(view);
        return !modCount.equals(currentModCount);
    }

    public Integer getModificationCount(View view) {
        if (view instanceof Snapshot) {
            return 0;
        }
        return this.modificationCounters.getOrDefault(view, 0);
    }
}

