/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.database;

import com.exonum.binding.proxy.CleanAction;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.database.ViewModificationCounter;
import com.exonum.binding.storage.database.Views;
import com.google.common.base.Preconditions;

public final class Fork
extends View {
    public static Fork newInstance(long nativeHandle, Cleaner cleaner) {
        return Fork.newInstance(nativeHandle, true, cleaner);
    }

    public static Fork newInstance(long nativeHandle, boolean owningHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner, (Object)"cleaner");
        NativeHandle h = new NativeHandle(nativeHandle);
        ProxyDestructor.newRegistered(cleaner, h, Fork.class, nh -> {
            if (owningHandle) {
                Views.nativeFree(nh);
            }
        });
        Fork f = new Fork(h, cleaner);
        cleaner.add(CleanAction.from(() -> ViewModificationCounter.getInstance().remove(f), "Fork in modification counter"));
        return f;
    }

    private Fork(NativeHandle nativeHandle, Cleaner cleaner) {
        super(nativeHandle, cleaner);
    }
}

