/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service.adapters;

import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.CloseFailuresException;
import com.exonum.binding.service.adapters.ViewFactory;
import com.exonum.binding.storage.database.Fork;
import com.exonum.binding.transaction.Transaction;
import com.exonum.binding.transaction.TransactionExecutionException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UserTransactionAdapter {
    private static final Logger logger = LogManager.getLogger(UserTransactionAdapter.class);
    @VisibleForTesting
    final Transaction transaction;
    private final ViewFactory viewFactory;

    public UserTransactionAdapter(Transaction transaction, ViewFactory viewFactory) {
        this.transaction = (Transaction)Preconditions.checkNotNull((Object)transaction, (Object)"Transaction must not be null");
        this.viewFactory = (ViewFactory)Preconditions.checkNotNull((Object)viewFactory, (Object)"viewFactory");
    }

    public boolean isValid() {
        try {
            return this.transaction.isValid();
        }
        catch (Throwable e) {
            this.logUnexpectedException(e);
            throw e;
        }
    }

    public void execute(long forkNativeHandle) throws TransactionExecutionException {
        try {
            assert (forkNativeHandle != 0L) : "Fork handle must not be 0";
            try (Cleaner cleaner = new Cleaner("Transaction#execute");){
                Fork view = this.viewFactory.createFork(forkNativeHandle, cleaner);
                this.transaction.execute(view);
            }
        }
        catch (TransactionExecutionException e) {
            logger.info("Transaction {} failed:", (Object)this.transaction, (Object)e);
            throw e;
        }
        catch (CloseFailuresException e) {
            logger.error("Failed to close some resources during transaction {} execution:", (Object)this.transaction, (Object)e);
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            this.logUnexpectedException(e);
            throw e;
        }
    }

    public String info() {
        try {
            return this.transaction.info();
        }
        catch (Throwable e) {
            this.logUnexpectedException(e);
            throw e;
        }
    }

    private void logUnexpectedException(Throwable e) {
        logger.error("Unexpected exception:", e);
    }
}

