/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LibraryLoader {
    private static final String BINDING_LIB_NAME = "java_bindings";
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    private static final String DYNAMIC_LIBRARIES_ENV_VAR = "LD_LIBRARY_PATH";
    private static final Logger logger = LogManager.getLogger(LibraryLoader.class);

    public static void load() {
        LibraryLoader.loadOnce();
    }

    private static void loadOnce() {
        try {
            System.loadLibrary(BINDING_LIB_NAME);
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Failed to load '{}' library: {}\u2026\n{}", (Object)BINDING_LIB_NAME, (Object)e, (Object)LibraryLoader.extraLibLoadErrorInfo());
            throw e;
        }
    }

    private static String extraLibLoadErrorInfo() {
        String javaLibPath = System.getProperty(JAVA_LIBRARY_PATH_PROPERTY);
        String dynamicLibPath = System.getenv(DYNAMIC_LIBRARIES_ENV_VAR);
        return "java.library.path=" + javaLibPath + ", \n" + DYNAMIC_LIBRARIES_ENV_VAR + "=" + dynamicLibPath + "\nMake sure that:\n1. The path to a directory containing '" + BINDING_LIB_NAME + "' dynamic library image is included in either java.library.path system property or " + DYNAMIC_LIBRARIES_ENV_VAR + " environment variable.\n2. The paths to directories containing dynamic libraries required by '" + BINDING_LIB_NAME + "', if any, are included in " + DYNAMIC_LIBRARIES_ENV_VAR + " environment variable";
    }

    private LibraryLoader() {
    }
}

