/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.AbstractListIndexProxy;
import com.exonum.binding.storage.indices.ListIndex;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.exonum.binding.storage.serialization.CheckingSerializerDecorator;
import com.exonum.binding.storage.serialization.Serializer;
import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import java.util.function.LongSupplier;

public final class ListIndexProxy<E>
extends AbstractListIndexProxy<E>
implements ListIndex<E> {
    public static <E> ListIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(name);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle listNativeHandle = ListIndexProxy.createNativeList(view, () -> ListIndexProxy.nativeCreate(name, viewNativeHandle));
        return new ListIndexProxy<E>(listNativeHandle, name, view, s);
    }

    public static <E> ListIndexProxy<E> newInGroupUnsafe(String groupName, byte[] listId, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(groupName);
        StoragePreconditions.checkIdInGroup(listId);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle listNativeHandle = ListIndexProxy.createNativeList(view, () -> ListIndexProxy.nativeCreateInGroup(groupName, listId, viewNativeHandle));
        return new ListIndexProxy<E>(listNativeHandle, groupName, view, s);
    }

    private static NativeHandle createNativeList(View view, LongSupplier nativeListConstructor) {
        NativeHandle listNativeHandle = new NativeHandle(nativeListConstructor.getAsLong());
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, listNativeHandle, ListIndexProxy.class, ListIndexProxy::nativeFree);
        return listNativeHandle;
    }

    private ListIndexProxy(NativeHandle nativeHandle, String name, View view, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, name, view, serializer);
    }

    public E removeLast() {
        this.notifyModified();
        byte[] e = this.nativeRemoveLast(this.getNativeHandle());
        if (e == null) {
            throw new NoSuchElementException("List is empty");
        }
        return (E)this.serializer.fromBytes(e);
    }

    public void truncate(long newSize) {
        Preconditions.checkArgument((newSize >= 0L ? 1 : 0) != 0, (String)"New size must be non-negative: %s", (long)newSize);
        this.notifyModified();
        this.nativeTruncate(this.getNativeHandle(), newSize);
    }

    private static native long nativeCreate(String var0, long var1);

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private static native void nativeFree(long var0);

    @Override
    native void nativeAdd(long var1, byte[] var3);

    @Override
    native void nativeSet(long var1, long var3, byte[] var5);

    @Override
    native byte[] nativeGet(long var1, long var3);

    @Override
    native byte[] nativeGetLast(long var1);

    native byte[] nativeRemoveLast(long var1);

    native void nativeTruncate(long var1, long var3);

    @Override
    native void nativeClear(long var1);

    @Override
    native boolean nativeIsEmpty(long var1);

    @Override
    native long nativeSize(long var1);

    @Override
    native long nativeCreateIter(long var1);

    @Override
    native byte[] nativeIterNext(long var1);

    @Override
    native void nativeIterFree(long var1);
}

