/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.proxy.AbstractNativeProxy;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.storage.database.Fork;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.database.ViewModificationCounter;
import com.exonum.binding.storage.indices.StorageIndex;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.google.common.base.Preconditions;

abstract class AbstractIndexProxy
extends AbstractNativeProxy
implements StorageIndex {
    final View dbView;
    final ViewModificationCounter modCounter;
    private final String name;

    AbstractIndexProxy(NativeHandle nativeHandle, String name, View view) {
        super(nativeHandle);
        this.name = StoragePreconditions.checkIndexName(name);
        this.dbView = (View)Preconditions.checkNotNull((Object)view);
        this.modCounter = ViewModificationCounter.getInstance();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    void notifyModified() {
        this.modCounter.notifyModified(this.castViewToFork());
    }

    private Fork castViewToFork() {
        if (!(this.dbView instanceof Fork)) {
            throw new UnsupportedOperationException("Cannot modify the view: " + this.dbView + "\nUse a Fork to modify any collection.");
        }
        return (Fork)this.dbView;
    }

    public String toString() {
        return this.name + ": " + this.getClass().getName();
    }
}

