/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.database;

import com.exonum.binding.proxy.AbstractCloseableNativeProxy;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.storage.database.Database;
import com.exonum.binding.storage.database.Fork;
import com.exonum.binding.storage.database.Snapshot;
import com.google.common.annotations.VisibleForTesting;

@VisibleForTesting
public final class MemoryDb
extends AbstractCloseableNativeProxy
implements Database {
    public static MemoryDb newInstance() {
        long nativeHandle = 0L;
        try {
            nativeHandle = MemoryDb.nativeCreate();
            return new MemoryDb(nativeHandle);
        }
        catch (Throwable t) {
            if (nativeHandle != 0L) {
                MemoryDb.nativeFree(nativeHandle);
            }
            throw t;
        }
    }

    @VisibleForTesting
    MemoryDb(long nativeHandle) {
        super(nativeHandle, true);
    }

    @Override
    public Snapshot createSnapshot(Cleaner cleaner) {
        long snapshotHandle = this.nativeCreateSnapshot(this.getNativeHandle());
        return Snapshot.newInstance(snapshotHandle, cleaner);
    }

    @Override
    public Fork createFork(Cleaner cleaner) {
        long forkHandle = this.nativeCreateFork(this.getNativeHandle());
        return Fork.newInstance(forkHandle, cleaner);
    }

    public void merge(Fork fork) {
        this.nativeMerge(this.getNativeHandle(), fork.getViewNativeHandle());
    }

    @Override
    protected void disposeInternal() {
        MemoryDb.nativeFree(this.getNativeHandle());
    }

    private static native long nativeCreate();

    private native long nativeCreateSnapshot(long var1);

    private native long nativeCreateFork(long var1);

    private native void nativeMerge(long var1, long var3);

    private static native void nativeFree(long var0);
}

