/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service;

import com.exonum.binding.messages.Transaction;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.CloseFailuresException;
import com.exonum.binding.service.Node;
import com.exonum.binding.storage.database.MemoryDb;
import com.exonum.binding.storage.database.Snapshot;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NodeFake
implements Node {
    private static final Logger logger = LogManager.getLogger(NodeFake.class);
    private final MemoryDb database;
    private final byte[] publicKey;

    public NodeFake(MemoryDb database) {
        this(database, new byte[0]);
    }

    public NodeFake(MemoryDb database, byte[] publicKey) {
        this.database = (MemoryDb)Preconditions.checkNotNull((Object)database);
        this.publicKey = (byte[])publicKey.clone();
    }

    @Override
    public void submitTransaction(Transaction transaction) {
        Preconditions.checkNotNull((Object)transaction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <ResultT> ResultT withSnapshot(Function<Snapshot, ResultT> snapshotFunction) {
        try (Cleaner cleaner = new Cleaner("NodeFake#withSnapshot");){
            Snapshot snapshot = this.database.createSnapshot(cleaner);
            ResultT ResultT = snapshotFunction.apply(snapshot);
            return ResultT;
        }
        catch (CloseFailuresException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getPublicKey() {
        return (byte[])this.publicKey.clone();
    }

    public MemoryDb getDatabase() {
        return this.database;
    }
}

