/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.proxy;

import com.exonum.binding.proxy.CleanAction;
import com.exonum.binding.proxy.CloseFailuresException;
import com.exonum.binding.proxy.FrequencyStatsFormatter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Cleaner
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(Cleaner.class);
    private static final int TOO_MANY_CLEAN_ACTIONS_LOG_THRESHOLD = 1000;
    private static final int TOO_MANY_CLEAN_ACTIONS_LOG_FREQUENCY = 100;
    private final Deque<CleanAction<?>> registeredCleanActions = new ArrayDeque();
    private final String description;
    private boolean closed;

    public Cleaner() {
        this("");
    }

    public Cleaner(String description) {
        this.description = (String)Preconditions.checkNotNull((Object)description);
        this.closed = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void add(CleanAction<?> cleanAction) {
        if (this.closed) {
            Throwable cleanActionError = null;
            try {
                cleanAction.clean();
            }
            catch (Throwable t) {
                this.logCleanActionFailure(cleanAction, t);
                cleanActionError = t;
            }
            String message = String.format("Cannot register a clean action (%s) in a closed context", cleanAction);
            IllegalStateException e = new IllegalStateException(message);
            if (cleanActionError != null) {
                e.addSuppressed(cleanActionError);
            }
            throw e;
        }
        this.registeredCleanActions.push(cleanAction);
        this.logIfTooManyCleaners();
    }

    private void logIfTooManyCleaners() {
        int numRegisteredCleaners = this.getNumRegisteredActions();
        if (numRegisteredCleaners >= 1000 && numRegisteredCleaners % 100 == 0) {
            String proxiesByTypeFrequency = FrequencyStatsFormatter.itemsFrequency(this.registeredCleanActions, Cleaner::getActionType);
            logger.warn("Many cleaners ({}) are registered in a context ({}): {}", (Object)numRegisteredCleaners, (Object)this, (Object)proxiesByTypeFrequency);
        }
    }

    private static Object getActionType(CleanAction<?> a) {
        Optional<?> rt = a.resourceType();
        if (rt.isPresent()) {
            return rt.get();
        }
        return "Unknown";
    }

    @Override
    public void close() throws CloseFailuresException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ArrayList<Throwable> suppressedExceptions = new ArrayList<Throwable>(0);
        while (!this.registeredCleanActions.isEmpty()) {
            CleanAction<?> cleanAction = this.registeredCleanActions.pop();
            try {
                cleanAction.clean();
            }
            catch (Throwable t) {
                suppressedExceptions.add(t);
                this.logCleanActionFailure(cleanAction, t);
            }
        }
        if (!suppressedExceptions.isEmpty()) {
            String message = String.format("%d exception(s) occurred when closing this context (%s), see the log messages above or the list of suppressed exceptions", suppressedExceptions.size(), this);
            CloseFailuresException e = new CloseFailuresException(message);
            suppressedExceptions.forEach(e::addSuppressed);
            throw e;
        }
    }

    private void logCleanActionFailure(CleanAction cleanAction, Throwable cleanException) {
        logger.error("Exception occurred when this context ({}) attempted to perform a clean operation ({}):", (Object)this, (Object)cleanAction, (Object)cleanException);
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumRegisteredActions() {
        return this.registeredCleanActions.size();
    }

    public String toString() {
        String hash = Integer.toHexString(System.identityHashCode(this));
        MoreObjects.ToStringHelper sb = MoreObjects.toStringHelper((Object)this);
        sb.add("hash", (Object)hash);
        if (!this.description.isEmpty()) {
            sb.add("description", (Object)this.description);
        }
        return sb.add("numRegisteredActions", this.getNumRegisteredActions()).add("closed", this.closed).toString();
    }
}

