/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.messages;

import com.exonum.binding.messages.Message;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;

abstract class Message_Builder2 {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private static final BaseEncoding HEX_ENCODING = BaseEncoding.base16().lowerCase();
    private byte networkId;
    private byte version;
    private short serviceId;
    private short messageType;
    private ByteBuffer body;
    private byte[] signature;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Message_Builder2() {
    }

    public static Message.Builder from(Message value) {
        return new Message.Builder().mergeFrom(value);
    }

    public Message.Builder setNetworkId(byte networkId) {
        this.networkId = networkId;
        this._unsetProperties.remove((Object)Property.NETWORK_ID);
        return (Message.Builder)this;
    }

    public byte getNetworkId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NETWORK_ID) ? 1 : 0) != 0, (Object)"networkId not set");
        return this.networkId;
    }

    public Message.Builder setVersion(byte version) {
        this.version = version;
        this._unsetProperties.remove((Object)Property.VERSION);
        return (Message.Builder)this;
    }

    public byte getVersion() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VERSION) ? 1 : 0) != 0, (Object)"version not set");
        return this.version;
    }

    public Message.Builder setServiceId(short serviceId) {
        this.serviceId = serviceId;
        this._unsetProperties.remove((Object)Property.SERVICE_ID);
        return (Message.Builder)this;
    }

    public short getServiceId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SERVICE_ID) ? 1 : 0) != 0, (Object)"serviceId not set");
        return this.serviceId;
    }

    public Message.Builder setMessageType(short messageType) {
        this.messageType = messageType;
        this._unsetProperties.remove((Object)Property.MESSAGE_TYPE);
        return (Message.Builder)this;
    }

    public short getMessageType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.MESSAGE_TYPE) ? 1 : 0) != 0, (Object)"messageType not set");
        return this.messageType;
    }

    public Message.Builder setBody(ByteBuffer body) {
        this.body = (ByteBuffer)Preconditions.checkNotNull((Object)body);
        this._unsetProperties.remove((Object)Property.BODY);
        return (Message.Builder)this;
    }

    public ByteBuffer getBody() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.BODY) ? 1 : 0) != 0, (Object)"body not set");
        return this.body;
    }

    public Message.Builder setSignature(byte[] signature) {
        this.signature = (byte[])signature.clone();
        this._unsetProperties.remove((Object)Property.SIGNATURE);
        return (Message.Builder)this;
    }

    public byte[] getSignature() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SIGNATURE) ? 1 : 0) != 0, (Object)"signature not set");
        return this.signature;
    }

    public Message.Builder mergeFrom(Message value) {
        Message.Builder _defaults = new Message.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.NETWORK_ID) || !Objects.equals(value.getNetworkId(), ((Message_Builder2)_defaults).getNetworkId())) {
            this.setNetworkId(value.getNetworkId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.VERSION) || !Objects.equals(value.getVersion(), ((Message_Builder2)_defaults).getVersion())) {
            this.setVersion(value.getVersion());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SERVICE_ID) || !Objects.equals(value.getServiceId(), ((Message_Builder2)_defaults).getServiceId())) {
            this.setServiceId(value.getServiceId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.MESSAGE_TYPE) || !Objects.equals(value.getMessageType(), ((Message_Builder2)_defaults).getMessageType())) {
            this.setMessageType(value.getMessageType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.BODY) || !Objects.equals(value.getBody(), ((Message_Builder2)_defaults).getBody())) {
            this.setBody(value.getBody());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SIGNATURE) || !Arrays.equals(value.getSignature(), ((Message_Builder2)_defaults).getSignature())) {
            this.setSignature(value.getSignature());
        }
        return (Message.Builder)this;
    }

    public Message.Builder mergeFrom(Message.Builder template) {
        Message.Builder base = template;
        Message.Builder _defaults = new Message.Builder();
        if (!(base._unsetProperties.contains((Object)Property.NETWORK_ID) || !_defaults._unsetProperties.contains((Object)Property.NETWORK_ID) && Objects.equals(template.getNetworkId(), ((Message_Builder2)_defaults).getNetworkId()))) {
            this.setNetworkId(template.getNetworkId());
        }
        if (!(base._unsetProperties.contains((Object)Property.VERSION) || !_defaults._unsetProperties.contains((Object)Property.VERSION) && Objects.equals(template.getVersion(), ((Message_Builder2)_defaults).getVersion()))) {
            this.setVersion(template.getVersion());
        }
        if (!(base._unsetProperties.contains((Object)Property.SERVICE_ID) || !_defaults._unsetProperties.contains((Object)Property.SERVICE_ID) && Objects.equals(template.getServiceId(), ((Message_Builder2)_defaults).getServiceId()))) {
            this.setServiceId(template.getServiceId());
        }
        if (!(base._unsetProperties.contains((Object)Property.MESSAGE_TYPE) || !_defaults._unsetProperties.contains((Object)Property.MESSAGE_TYPE) && Objects.equals(template.getMessageType(), ((Message_Builder2)_defaults).getMessageType()))) {
            this.setMessageType(template.getMessageType());
        }
        if (!(base._unsetProperties.contains((Object)Property.BODY) || !_defaults._unsetProperties.contains((Object)Property.BODY) && Objects.equals(template.getBody(), ((Message_Builder2)_defaults).getBody()))) {
            this.setBody(template.getBody());
        }
        if (!(base._unsetProperties.contains((Object)Property.SIGNATURE) || !_defaults._unsetProperties.contains((Object)Property.SIGNATURE) && Arrays.equals(template.getSignature(), ((Message_Builder2)_defaults).getSignature()))) {
            this.setSignature(template.getSignature());
        }
        return (Message.Builder)this;
    }

    public Message.Builder clear() {
        Message.Builder _defaults = new Message.Builder();
        this.networkId = _defaults.networkId;
        this.version = _defaults.version;
        this.serviceId = _defaults.serviceId;
        this.messageType = _defaults.messageType;
        this.body = _defaults.body;
        this.signature = _defaults.signature;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (Message.Builder)this;
    }

    public Message build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public Message buildPartial() {
        return new Partial(this);
    }

    @VisibleForTesting
    static final class Partial
    implements Message {
        private final byte networkId;
        private final byte version;
        private final short serviceId;
        private final short messageType;
        private final ByteBuffer body;
        private final byte[] signature;
        private final EnumSet<Property> _unsetProperties;

        Partial(Message_Builder2 builder) {
            this.networkId = builder.networkId;
            this.version = builder.version;
            this.serviceId = builder.serviceId;
            this.messageType = builder.messageType;
            this.body = builder.body;
            this.signature = builder.signature;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public byte getNetworkId() {
            if (this._unsetProperties.contains((Object)Property.NETWORK_ID)) {
                throw new UnsupportedOperationException("networkId not set");
            }
            return this.networkId;
        }

        @Override
        public byte getVersion() {
            if (this._unsetProperties.contains((Object)Property.VERSION)) {
                throw new UnsupportedOperationException("version not set");
            }
            return this.version;
        }

        @Override
        public short getServiceId() {
            if (this._unsetProperties.contains((Object)Property.SERVICE_ID)) {
                throw new UnsupportedOperationException("serviceId not set");
            }
            return this.serviceId;
        }

        @Override
        public short getMessageType() {
            if (this._unsetProperties.contains((Object)Property.MESSAGE_TYPE)) {
                throw new UnsupportedOperationException("messageType not set");
            }
            return this.messageType;
        }

        @Override
        public ByteBuffer getBody() {
            if (this._unsetProperties.contains((Object)Property.BODY)) {
                throw new UnsupportedOperationException("body not set");
            }
            return this.body.duplicate();
        }

        @Override
        public byte[] getSignature() {
            if (this._unsetProperties.contains((Object)Property.SIGNATURE)) {
                throw new UnsupportedOperationException("signature not set");
            }
            return (byte[])this.signature.clone();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.networkId, other.networkId) && Objects.equals(this.version, other.version) && Objects.equals(this.serviceId, other.serviceId) && Objects.equals(this.messageType, other.messageType) && Objects.equals(this.body, other.body) && Arrays.equals(this.signature, other.signature) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            int signatureHash = Arrays.hashCode(this.signature);
            return Objects.hash(this.networkId, this.version, this.serviceId, this.messageType, this.body, signatureHash, this._unsetProperties);
        }

        public String toString() {
            return "partial Message{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.NETWORK_ID) ? "networkId=" + this.networkId : null), (Object)(!this._unsetProperties.contains((Object)Property.VERSION) ? "version=" + this.version : null), new Object[]{!this._unsetProperties.contains((Object)Property.SERVICE_ID) ? "serviceId=" + this.serviceId : null, !this._unsetProperties.contains((Object)Property.MESSAGE_TYPE) ? "messageType=" + this.messageType : null, !this._unsetProperties.contains((Object)Property.BODY) ? "body=" + this.body : null, !this._unsetProperties.contains((Object)Property.SIGNATURE) ? "signature=" + HEX_ENCODING.encode(this.signature) : null}) + "}";
        }
    }

    @VisibleForTesting
    static final class Value
    implements Message {
        private final byte networkId;
        private final byte version;
        private final short serviceId;
        private final short messageType;
        private final ByteBuffer body;
        private final byte[] signature;

        private Value(Message_Builder2 builder) {
            this.networkId = builder.networkId;
            this.version = builder.version;
            this.serviceId = builder.serviceId;
            this.messageType = builder.messageType;
            this.body = builder.body;
            this.signature = builder.signature;
        }

        @Override
        public byte getNetworkId() {
            return this.networkId;
        }

        @Override
        public byte getVersion() {
            return this.version;
        }

        @Override
        public short getServiceId() {
            return this.serviceId;
        }

        @Override
        public short getMessageType() {
            return this.messageType;
        }

        @Override
        public ByteBuffer getBody() {
            return this.body.duplicate();
        }

        @Override
        public byte[] getSignature() {
            return (byte[])this.signature.clone();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.networkId, other.networkId) && Objects.equals(this.version, other.version) && Objects.equals(this.serviceId, other.serviceId) && Objects.equals(this.messageType, other.messageType) && Objects.equals(this.body, other.body) && Arrays.equals(this.signature, other.signature);
        }

        public int hashCode() {
            int signatureHash = Arrays.hashCode(this.signature);
            return Objects.hash(this.networkId, this.version, this.serviceId, this.messageType, this.body, signatureHash);
        }

        public String toString() {
            return "Message{networkId=" + this.networkId + ", version=" + this.version + ", serviceId=" + this.serviceId + ", messageType=" + this.messageType + ", body=" + this.body + ", signature=" + HEX_ENCODING.encode(this.signature) + "}";
        }
    }

    private static enum Property {
        NETWORK_ID("networkId"),
        VERSION("version"),
        SERVICE_ID("serviceId"),
        MESSAGE_TYPE("messageType"),
        BODY("body"),
        SIGNATURE("signature");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

