/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.messages;

import com.exonum.binding.messages.BinaryMessage;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class MessageReader
implements BinaryMessage {
    static final int MIN_MESSAGE_BUFFER_SIZE = 74;
    private final ByteBuffer message;

    public static MessageReader wrap(ByteBuffer buffer) {
        MessageReader reader = new MessageReader(buffer);
        int bufferSize = buffer.limit();
        Preconditions.checkArgument((74 <= bufferSize ? 1 : 0) != 0, (String)"The buffer size (%s) is less than the minimal possible message size (%s)", (int)bufferSize, (int)74);
        int expectedSize = reader.size();
        Preconditions.checkArgument((bufferSize == expectedSize ? 1 : 0) != 0, (String)"The size of the buffer (%s) does not match the expected size specified in the message header (%s)", (int)bufferSize, (int)expectedSize);
        return reader;
    }

    private MessageReader(ByteBuffer buf) {
        this.message = buf.duplicate().order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte getNetworkId() {
        return this.message.get(0);
    }

    @Override
    public byte getVersion() {
        return this.message.get(1);
    }

    @Override
    public short getServiceId() {
        return this.message.getShort(4);
    }

    @Override
    public short getMessageType() {
        return this.message.getShort(2);
    }

    @Override
    public ByteBuffer getBody() {
        this.message.position(10);
        ByteBuffer body = this.message.slice();
        body.limit(this.bodySize());
        return body;
    }

    private int bodySize() {
        return this.size() - 10 - 64;
    }

    @Override
    public byte[] getSignature() {
        this.message.position(this.signatureOffset());
        byte[] signature = new byte[64];
        this.message.get(signature);
        return signature;
    }

    @Override
    public int size() {
        return this.message.getInt(6);
    }

    @Override
    public ByteBuffer getSignedMessage() {
        this.message.position(0);
        return this.message.duplicate();
    }
}

