/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.messages;

import com.exonum.binding.messages.BinaryMessage;
import com.exonum.binding.messages.Message;
import com.exonum.binding.messages.MessageReader;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.IntFunction;

public final class BinaryMessageBuilder {
    private static final IntFunction<ByteBuffer> messageBufferAllocator = ByteBuffer::allocate;
    private final Message message;

    public static BinaryMessage toBinary(Message message) {
        if (message instanceof MessageReader) {
            return (MessageReader)message;
        }
        return new BinaryMessageBuilder(message).build();
    }

    BinaryMessageBuilder(Message message) {
        this.message = (Message)Preconditions.checkNotNull((Object)message);
    }

    BinaryMessage build() {
        ByteBuffer buffer = this.allocateBuffer();
        this.putHeader(buffer);
        this.putBody(buffer);
        this.putSignature(buffer);
        buffer.flip();
        return MessageReader.wrap(buffer);
    }

    private ByteBuffer allocateBuffer() {
        int size = this.message.size();
        return messageBufferAllocator.apply(size).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void putHeader(ByteBuffer buffer) {
        buffer.put(0, this.message.getNetworkId()).put(1, this.message.getVersion()).putShort(4, this.message.getServiceId()).putShort(2, this.message.getMessageType()).putInt(6, this.message.size());
    }

    private void putBody(ByteBuffer buffer) {
        buffer.position(10);
        buffer.put(this.message.getBody());
    }

    private void putSignature(ByteBuffer buffer) {
        buffer.position(this.message.signatureOffset());
        buffer.put(this.message.getSignature());
    }
}

