/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.crypto;

import com.exonum.binding.crypto.CryptoFunction;
import com.exonum.binding.crypto.CryptoUtils;
import com.exonum.binding.crypto.KeyPair;
import com.exonum.binding.crypto.PrivateKey;
import com.exonum.binding.crypto.PublicKey;
import com.google.common.base.Preconditions;
import jnr.ffi.byref.LongLongByReference;
import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Random;
import org.abstractj.kalium.crypto.Util;

public enum Ed25519CryptoFunction implements CryptoFunction
{
    INSTANCE;

    private static int CRYPTO_SIGN_ED25519_SEEDBYTES;

    @Override
    public KeyPair generateKeyPair(byte[] seed) {
        Preconditions.checkArgument((boolean)CryptoUtils.hasLength(seed, CRYPTO_SIGN_ED25519_SEEDBYTES), (String)"Seed byte array has invalid size (%s), must be 64", (int)seed.length);
        byte[] privateKey = Util.zeros((int)64);
        byte[] publicKey = Util.zeros((int)32);
        if (!CryptoUtils.checkReturnValueSuccess(NaCl.sodium().crypto_sign_ed25519_seed_keypair(publicKey, privateKey, seed))) {
            throw new RuntimeException("Failed to generate a key pair");
        }
        return KeyPair.createKeyPairNoCopy(privateKey, publicKey);
    }

    @Override
    public KeyPair generateKeyPair() {
        return this.generateKeyPair(new Random().randomBytes(CRYPTO_SIGN_ED25519_SEEDBYTES));
    }

    @Override
    public byte[] signMessage(byte[] message, PrivateKey privateKey) {
        byte[] signedMessage = Util.prependZeros((int)64, (byte[])message);
        LongLongByReference bufferLen = new LongLongByReference(0L);
        NaCl.sodium().crypto_sign_ed25519(signedMessage, bufferLen, message, message.length, privateKey.toBytesNoCopy());
        byte[] signature = Util.slice((byte[])signedMessage, (int)0, (int)64);
        return signature;
    }

    @Override
    public boolean verify(byte[] message, byte[] signature, PublicKey publicKey) {
        if (!CryptoUtils.hasLength(signature, 64)) {
            return false;
        }
        byte[] sigAndMsg = Util.merge((byte[])signature, (byte[])message);
        byte[] buffer = Util.zeros((int)sigAndMsg.length);
        LongLongByReference bufferLen = new LongLongByReference(0L);
        return CryptoUtils.checkReturnValueSuccess(NaCl.sodium().crypto_sign_ed25519_open(buffer, bufferLen, sigAndMsg, sigAndMsg.length, publicKey.toBytesNoCopy()));
    }

    static {
        CRYPTO_SIGN_ED25519_SEEDBYTES = 64;
    }
}

