/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.crypto;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.abstractj.kalium.encoders.Encoder;

public abstract class AbstractKey {
    private final byte[] rawKey;

    AbstractKey(byte[] rawKey) {
        Preconditions.checkArgument((rawKey.length > 0 ? 1 : 0) != 0, (Object)"Key must not be empty");
        this.rawKey = rawKey;
    }

    public byte[] toBytes() {
        return (byte[])this.rawKey.clone();
    }

    byte[] toBytesNoCopy() {
        return this.rawKey;
    }

    public int size() {
        return this.rawKey.length;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            AbstractKey that = (AbstractKey)o;
            return Arrays.equals(this.rawKey, that.rawKey);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.rawKey);
    }

    public String toString() {
        return Encoder.HEX.encode(this.rawKey);
    }
}

