/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.AbstractIndexProxy;
import com.exonum.binding.core.storage.indices.AutoValue_ValueSetIndexProxy_Entry;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.StorageIterators;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ValueSetIndexProxy<E>
extends AbstractIndexProxy
implements Iterable<Entry<E>> {
    private static final int BASE_SPLITERATOR_CHARACTERISTICS = 272;
    private final CheckingSerializerDecorator<E> serializer;

    public static <E> ValueSetIndexProxy<E> newInstance(IndexAddress address, AbstractAccess access, Serializer<E> serializer) {
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle setNativeHandle = ValueSetIndexProxy.createNativeSet(address, access);
        return new ValueSetIndexProxy<E>(setNativeHandle, address, access, s);
    }

    private static NativeHandle createNativeSet(IndexAddress address, AbstractAccess access) {
        long accessNativeHandle = access.getAccessNativeHandle();
        long handle = ValueSetIndexProxy.nativeCreate(address.getName(), address.getIdInGroup().orElse(null), accessNativeHandle);
        NativeHandle setNativeHandle = new NativeHandle(handle);
        Cleaner cleaner = access.getCleaner();
        ProxyDestructor.newRegistered(cleaner, setNativeHandle, ValueSetIndexProxy.class, ValueSetIndexProxy::nativeFree);
        return setNativeHandle;
    }

    private ValueSetIndexProxy(NativeHandle nativeHandle, IndexAddress address, AbstractAccess access, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, address, access);
        this.serializer = serializer;
    }

    public void add(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeAdd(this.getNativeHandle(), dbElement);
    }

    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    public boolean contains(E e) {
        byte[] dbElement = this.serializer.toBytes(e);
        return this.nativeContains(this.getNativeHandle(), dbElement);
    }

    public boolean containsByHash(HashCode elementHash) {
        return this.nativeContainsByHash(this.getNativeHandle(), elementHash.asBytes());
    }

    public Iterator<HashCode> hashes() {
        return StorageIterators.createIterator(this.nativeCreateHashIterator(this.getNativeHandle()), this::nativeHashIteratorNext, this::nativeHashIteratorFree, this.dbAccess, this.modCounter, HashCode::fromBytes);
    }

    @Override
    public Iterator<Entry<E>> iterator() {
        return StorageIterators.createIterator(this.nativeCreateIterator(this.getNativeHandle()), this::nativeIteratorNext, this::nativeIteratorFree, this.dbAccess, this.modCounter, e -> Entry.fromInternal(e, this.serializer));
    }

    private native long nativeCreateIterator(long var1);

    private native EntryInternal nativeIteratorNext(long var1);

    private native void nativeIteratorFree(long var1);

    public Stream<Entry<E>> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), this.streamCharacteristics()), false);
    }

    private int streamCharacteristics() {
        if (this.dbAccess.canModify()) {
            return 272;
        }
        return 1296;
    }

    public void remove(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeRemove(this.getNativeHandle(), dbElement);
    }

    public void removeByHash(HashCode elementHash) {
        this.notifyModified();
        this.nativeRemoveByHash(this.getNativeHandle(), elementHash.asBytes());
    }

    private static native long nativeCreate(String var0, @Nullable byte[] var1, long var2);

    private native void nativeAdd(long var1, byte[] var3);

    private native void nativeClear(long var1);

    private native boolean nativeContains(long var1, byte[] var3);

    private native boolean nativeContainsByHash(long var1, byte[] var3);

    private native long nativeCreateHashIterator(long var1);

    @Nullable
    private native byte[] nativeHashIteratorNext(long var1);

    private native void nativeHashIteratorFree(long var1);

    private native void nativeRemove(long var1, byte[] var3);

    private native void nativeRemoveByHash(long var1, byte[] var3);

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
    }

    private static class EntryInternal {
        final byte[] hash;
        final byte[] value;

        private EntryInternal(byte[] hash, byte[] value) {
            this.hash = (byte[])Preconditions.checkNotNull((Object)hash);
            this.value = StoragePreconditions.checkStorageValue(value);
        }
    }

    @AutoValue
    public static abstract class Entry<E> {
        public abstract HashCode getHash();

        public abstract E getValue();

        public final int hashCode() {
            return this.getHash().hashCode();
        }

        private static <E> Entry<E> fromInternal(EntryInternal e, Serializer<E> serializer) {
            HashCode hash = HashCode.fromBytes((byte[])e.hash);
            Object value = serializer.fromBytes(e.value);
            return Entry.from(hash, value);
        }

        @VisibleForTesting
        static <E> Entry<E> from(HashCode hash, E value) {
            return new AutoValue_ValueSetIndexProxy_Entry<E>(hash, value);
        }
    }
}

