/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.ConfigurableRustIter;
import com.exonum.binding.core.storage.indices.ModificationCounter;
import com.exonum.binding.core.storage.indices.RustIter;
import com.exonum.binding.core.storage.indices.RustIterAdapter;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;

final class StorageIterators {
    static <ElementT, NativeT> Iterator<ElementT> createIterator(long nativeHandle, LongFunction<NativeT> nextFunction, LongConsumer disposeOperation, AbstractAccess collectionAccess, ModificationCounter modificationCounter, Function<? super NativeT, ? extends ElementT> transformingFunction) {
        NativeHandle handle = new NativeHandle(nativeHandle);
        Cleaner cleaner = collectionAccess.getCleaner();
        cleaner.add(new ProxyDestructor(handle, RustIter.class, disposeOperation));
        RustIterAdapter<NativeT> iterator = new RustIterAdapter<NativeT>(new ConfigurableRustIter<NativeT>(handle, nextFunction, modificationCounter));
        return Iterators.transform(iterator, transformingFunction::apply);
    }

    private StorageIterators() {
    }
}

