/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.collect.MapEntry;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.AbstractIndexProxy;
import com.exonum.binding.core.storage.indices.HashableIndex;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.MapEntryInternal;
import com.exonum.binding.core.storage.indices.MapIndex;
import com.exonum.binding.core.storage.indices.MapProof;
import com.exonum.binding.core.storage.indices.ProofMapKeyCheckingSerializerDecorator;
import com.exonum.binding.core.storage.indices.StorageIterators;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ProofMapIndexProxy<K, V>
extends AbstractIndexProxy
implements MapIndex<K, V>,
HashableIndex {
    private final Serializer<K> keySerializer;
    private final CheckingSerializerDecorator<V> valueSerializer;

    public static <K, V> ProofMapIndexProxy<K, V> newInstance(IndexAddress address, AbstractAccess access, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return ProofMapIndexProxy.newMapIndexProxy(address, access, keySerializer, valueSerializer, true);
    }

    public static <K, V> ProofMapIndexProxy<K, V> newInstanceNoKeyHashing(IndexAddress address, AbstractAccess access, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return ProofMapIndexProxy.newMapIndexProxy(address, access, keySerializer, valueSerializer, false);
    }

    private static <K, V> ProofMapIndexProxy<K, V> newMapIndexProxy(IndexAddress address, AbstractAccess access, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean keyHashing) {
        Serializer<K> ks = ProofMapIndexProxy.decorateKeySerializer(keySerializer, keyHashing);
        CheckingSerializerDecorator vs = CheckingSerializerDecorator.from(valueSerializer);
        NativeHandle mapNativeHandle = ProofMapIndexProxy.createNativeMap(address, access, keyHashing);
        return new ProofMapIndexProxy<K, V>(mapNativeHandle, address, access, ks, vs);
    }

    private static <K> Serializer<K> decorateKeySerializer(Serializer<K> keySerializer, boolean keyHashing) {
        if (!keyHashing) {
            return ProofMapKeyCheckingSerializerDecorator.from(keySerializer);
        }
        return CheckingSerializerDecorator.from(keySerializer);
    }

    private static NativeHandle createNativeMap(IndexAddress address, AbstractAccess access, boolean keyHashing) {
        long accessNativeHandle = access.getAccessNativeHandle();
        long handle = ProofMapIndexProxy.nativeCreate(address.getName(), address.getIdInGroup().orElse(null), accessNativeHandle, keyHashing);
        NativeHandle mapNativeHandle = new NativeHandle(handle);
        Cleaner cleaner = access.getCleaner();
        ProxyDestructor.newRegistered(cleaner, mapNativeHandle, ProofMapIndexProxy.class, ProofMapIndexProxy::nativeFree);
        return mapNativeHandle;
    }

    private static native long nativeCreate(String var0, @Nullable byte[] var1, long var2, boolean var4);

    private ProofMapIndexProxy(NativeHandle nativeHandle, IndexAddress address, AbstractAccess access, Serializer<K> keySerializer, CheckingSerializerDecorator<V> valueSerializer) {
        super(nativeHandle, address, access);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public boolean containsKey(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        return this.nativeContainsKey(this.getNativeHandle(), dbKey);
    }

    private native boolean nativeContainsKey(long var1, byte[] var3);

    @Override
    public void put(K key, V value) {
        this.notifyModified();
        long nativeHandle = this.getNativeHandle();
        this.putInternal(nativeHandle, key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> sourceMap) {
        this.notifyModified();
        long nativeHandle = this.getNativeHandle();
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            this.putInternal(nativeHandle, entry.getKey(), entry.getValue());
        }
    }

    private void putInternal(long nativeHandle, K key, V value) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.valueSerializer.toBytes(value);
        this.nativePut(nativeHandle, dbKey, dbValue);
    }

    private native void nativePut(long var1, byte[] var3, byte[] var4);

    @Override
    public V get(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.nativeGet(this.getNativeHandle(), dbKey);
        return (V)(dbValue == null ? null : this.valueSerializer.fromBytes(dbValue));
    }

    private native byte[] nativeGet(long var1, byte[] var3);

    public MapProof getProof(K key, K ... otherKeys) {
        if (otherKeys.length == 0) {
            return this.getSingleKeyProof(key);
        }
        List keys = Lists.asList(key, (Object[])otherKeys);
        return this.getMultiKeyProof(keys);
    }

    public MapProof getProof(Collection<? extends K> keys) {
        Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (Object)"Keys collection should not be empty");
        if (keys.size() == 1) {
            K key = keys.iterator().next();
            return this.getSingleKeyProof(key);
        }
        return this.getMultiKeyProof(keys);
    }

    private MapProof getSingleKeyProof(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] proofMessage = this.nativeGetProof(this.getNativeHandle(), dbKey);
        return ProofMapIndexProxy.decodeProofMessage(proofMessage);
    }

    private native byte[] nativeGetProof(long var1, byte[] var3);

    private MapProof getMultiKeyProof(Collection<? extends K> keys) {
        byte[][] dbKeys = this.keysToArray(keys);
        byte[] proofMessage = this.nativeGetMultiProof(this.getNativeHandle(), dbKeys);
        return ProofMapIndexProxy.decodeProofMessage(proofMessage);
    }

    private byte[][] keysToArray(Collection<? extends K> keys) {
        return (byte[][])keys.stream().map(arg_0 -> this.keySerializer.toBytes(arg_0)).toArray(x$0 -> new byte[x$0][]);
    }

    private native byte[] nativeGetMultiProof(long var1, byte[][] var3);

    private static MapProof decodeProofMessage(byte[] proofMessage) {
        try {
            return MapProof.parseFrom(proofMessage);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Non-decodable proof message", e);
        }
    }

    @Override
    public HashCode getIndexHash() {
        return HashCode.fromBytes((byte[])this.nativeGetIndexHash(this.getNativeHandle()));
    }

    private native byte[] nativeGetIndexHash(long var1);

    @Override
    public void remove(K key) {
        this.notifyModified();
        byte[] dbKey = this.keySerializer.toBytes(key);
        this.nativeRemove(this.getNativeHandle(), dbKey);
    }

    private native void nativeRemove(long var1, byte[] var3);

    @Override
    public Iterator<K> keys() {
        return StorageIterators.createIterator(this.nativeCreateKeysIter(this.getNativeHandle()), this::nativeKeysIterNext, this::nativeKeysIterFree, this.dbAccess, this.modCounter, arg_0 -> this.keySerializer.fromBytes(arg_0));
    }

    private native long nativeCreateKeysIter(long var1);

    private native byte[] nativeKeysIterNext(long var1);

    private native void nativeKeysIterFree(long var1);

    @Override
    public Iterator<V> values() {
        return StorageIterators.createIterator(this.nativeCreateValuesIter(this.getNativeHandle()), this::nativeValuesIterNext, this::nativeValuesIterFree, this.dbAccess, this.modCounter, arg_0 -> this.valueSerializer.fromBytes(arg_0));
    }

    private native long nativeCreateValuesIter(long var1);

    private native byte[] nativeValuesIterNext(long var1);

    private native void nativeValuesIterFree(long var1);

    @Override
    public Iterator<MapEntry<K, V>> entries() {
        return StorageIterators.createIterator(this.nativeCreateEntriesIter(this.getNativeHandle()), this::nativeEntriesIterNext, this::nativeEntriesIterFree, this.dbAccess, this.modCounter, entry -> entry.toMapEntry((MapEntryInternal)entry, this.keySerializer, this.valueSerializer));
    }

    private native long nativeCreateEntriesIter(long var1);

    private native MapEntryInternal nativeEntriesIterNext(long var1);

    private native void nativeEntriesIterFree(long var1);

    @Override
    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    private native void nativeClear(long var1);

    private static native void nativeFree(long var0);
}

