/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.AbstractListIndexProxy;
import com.exonum.binding.core.storage.indices.HashableIndex;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.ListIndex;
import com.exonum.binding.core.storage.indices.ListProof;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.protobuf.InvalidProtocolBufferException;
import javax.annotation.Nullable;

public final class ProofListIndexProxy<E>
extends AbstractListIndexProxy<E>
implements ListIndex<E>,
HashableIndex {
    public static <E> ProofListIndexProxy<E> newInstance(IndexAddress address, AbstractAccess access, Serializer<E> serializer) {
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle listNativeHandle = ProofListIndexProxy.createNativeList(address, access);
        return new ProofListIndexProxy<E>(listNativeHandle, address, access, s);
    }

    private static NativeHandle createNativeList(IndexAddress address, AbstractAccess access) {
        long accessNativeHandle = access.getAccessNativeHandle();
        long handle = ProofListIndexProxy.nativeCreate(address.getName(), address.getIdInGroup().orElse(null), accessNativeHandle);
        NativeHandle listNativeHandle = new NativeHandle(handle);
        Cleaner cleaner = access.getCleaner();
        ProxyDestructor.newRegistered(cleaner, listNativeHandle, ProofListIndexProxy.class, ProofListIndexProxy::nativeFree);
        return listNativeHandle;
    }

    private static native long nativeCreate(String var0, @Nullable byte[] var1, long var2);

    private ProofListIndexProxy(NativeHandle nativeHandle, IndexAddress address, AbstractAccess access, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, address, access, serializer);
    }

    public ListProof getProof(long index) {
        byte[] proofMessage = this.nativeGetProof(this.getNativeHandle(), index);
        return ProofListIndexProxy.parseProof(proofMessage);
    }

    private native byte[] nativeGetProof(long var1, long var3);

    public ListProof getRangeProof(long from, long to) {
        StoragePreconditions.checkRange(from, to);
        byte[] proofMessage = this.nativeGetRangeProof(this.getNativeHandle(), from, to);
        return ProofListIndexProxy.parseProof(proofMessage);
    }

    private native byte[] nativeGetRangeProof(long var1, long var3, long var5);

    private static ListProof parseProof(byte[] proofMessage) {
        try {
            return ListProof.parseFrom(proofMessage);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Non-decodable list proof", e);
        }
    }

    @Override
    public HashCode getIndexHash() {
        return HashCode.fromBytes((byte[])this.nativeGetIndexHash(this.getNativeHandle()));
    }

    private native byte[] nativeGetIndexHash(long var1);

    private static native void nativeFree(long var0);

    @Override
    native void nativeAdd(long var1, byte[] var3);

    @Override
    native void nativeSet(long var1, long var3, byte[] var5);

    @Override
    native byte[] nativeGet(long var1, long var3);

    @Override
    native byte[] nativeGetLast(long var1);

    @Override
    native byte[] nativeRemoveLast(long var1);

    @Override
    native void nativeTruncate(long var1, long var3);

    @Override
    native void nativeClear(long var1);

    @Override
    native boolean nativeIsEmpty(long var1);

    @Override
    native long nativeSize(long var1);

    @Override
    native long nativeCreateIter(long var1);

    @Override
    native byte[] nativeIterNext(long var1);

    @Override
    native void nativeIterFree(long var1);

    static {
        LibraryLoader.load();
    }
}

