/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.AbstractEntryIndexProxy;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.ProofEntryIndex;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.common.base.Preconditions;

public final class ProofEntryIndexProxy<T>
extends AbstractEntryIndexProxy<T>
implements ProofEntryIndex<T> {
    public static <E> ProofEntryIndexProxy<E> newInstance(IndexAddress address, AbstractAccess access, Serializer<E> serializer) {
        Preconditions.checkArgument((boolean)address.getIdInGroup().isEmpty(), (Object)"Groups of Entries are not supported, use a ProofMapIndex instead");
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle entryNativeHandle = ProofEntryIndexProxy.createNativeEntry(address.getName(), access);
        return new ProofEntryIndexProxy(entryNativeHandle, address, access, s);
    }

    private static NativeHandle createNativeEntry(String name, AbstractAccess access) {
        long accessNativeHandle = access.getAccessNativeHandle();
        long handle = ProofEntryIndexProxy.nativeCreate(name, accessNativeHandle);
        NativeHandle entryNativeHandle = new NativeHandle(handle);
        Cleaner cleaner = access.getCleaner();
        ProxyDestructor.newRegistered(cleaner, entryNativeHandle, ProofEntryIndexProxy.class, ProofEntryIndexProxy::nativeFree);
        return entryNativeHandle;
    }

    private ProofEntryIndexProxy(NativeHandle nativeHandle, IndexAddress address, AbstractAccess access, CheckingSerializerDecorator<T> serializer) {
        super(nativeHandle, address, access, serializer);
    }

    @Override
    public HashCode getIndexHash() {
        return HashCode.fromBytes((byte[])this.nativeGetIndexHash(this.getNativeHandle()));
    }

    private static native long nativeCreate(String var0, long var1);

    @Override
    protected native void nativeSet(long var1, byte[] var3);

    @Override
    protected native boolean nativeIsPresent(long var1);

    @Override
    protected native byte[] nativeGet(long var1);

    @Override
    protected native byte[] nativeGetIndexHash(long var1);

    @Override
    protected native void nativeRemove(long var1);

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
    }
}

