/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.collect.MapEntry;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.AbstractIndexProxy;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.MapEntryInternal;
import com.exonum.binding.core.storage.indices.MapIndex;
import com.exonum.binding.core.storage.indices.StorageIterators;
import com.exonum.binding.core.util.LibraryLoader;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public final class MapIndexProxy<K, V>
extends AbstractIndexProxy
implements MapIndex<K, V> {
    private final CheckingSerializerDecorator<K> keySerializer;
    private final CheckingSerializerDecorator<V> valueSerializer;

    public static <K, V> MapIndexProxy<K, V> newInstance(IndexAddress address, AbstractAccess access, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        CheckingSerializerDecorator ks = CheckingSerializerDecorator.from(keySerializer);
        CheckingSerializerDecorator vs = CheckingSerializerDecorator.from(valueSerializer);
        NativeHandle mapNativeHandle = MapIndexProxy.createNativeMap(address, access);
        return new MapIndexProxy<K, V>(mapNativeHandle, address, access, ks, vs);
    }

    private static NativeHandle createNativeMap(IndexAddress address, AbstractAccess access) {
        long accessNativeHandle = access.getAccessNativeHandle();
        long handle = MapIndexProxy.nativeCreate(address.getName(), address.getIdInGroup().orElse(null), accessNativeHandle);
        NativeHandle mapNativeHandle = new NativeHandle(handle);
        Cleaner cleaner = access.getCleaner();
        ProxyDestructor.newRegistered(cleaner, mapNativeHandle, MapIndexProxy.class, MapIndexProxy::nativeFree);
        return mapNativeHandle;
    }

    private MapIndexProxy(NativeHandle nativeHandle, IndexAddress address, AbstractAccess access, CheckingSerializerDecorator<K> keySerializer, CheckingSerializerDecorator<V> valueSerializer) {
        super(nativeHandle, address, access);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public boolean containsKey(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        return this.nativeContainsKey(this.getNativeHandle(), dbKey);
    }

    @Override
    public void put(K key, V value) {
        this.notifyModified();
        this.putInternal(this.getNativeHandle(), key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> sourceMap) {
        this.notifyModified();
        long nativeHandle = this.getNativeHandle();
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            this.putInternal(nativeHandle, entry.getKey(), entry.getValue());
        }
    }

    private void putInternal(long thisNativeHandle, K key, V value) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.valueSerializer.toBytes(value);
        this.nativePut(thisNativeHandle, dbKey, dbValue);
    }

    @Override
    public V get(K key) {
        byte[] dbKey = this.keySerializer.toBytes(key);
        byte[] dbValue = this.nativeGet(this.getNativeHandle(), dbKey);
        return (V)(dbValue == null ? null : this.valueSerializer.fromBytes(dbValue));
    }

    @Override
    public void remove(K key) {
        this.notifyModified();
        byte[] dbKey = this.keySerializer.toBytes(key);
        this.nativeRemove(this.getNativeHandle(), dbKey);
    }

    @Override
    public Iterator<K> keys() {
        return StorageIterators.createIterator(this.nativeCreateKeysIter(this.getNativeHandle()), this::nativeKeysIterNext, this::nativeKeysIterFree, this.dbAccess, this.modCounter, arg_0 -> this.keySerializer.fromBytes(arg_0));
    }

    @Override
    public Iterator<V> values() {
        return StorageIterators.createIterator(this.nativeCreateValuesIter(this.getNativeHandle()), this::nativeValuesIterNext, this::nativeValuesIterFree, this.dbAccess, this.modCounter, arg_0 -> this.valueSerializer.fromBytes(arg_0));
    }

    @Override
    public Iterator<MapEntry<K, V>> entries() {
        return StorageIterators.createIterator(this.nativeCreateEntriesIter(this.getNativeHandle()), this::nativeEntriesIterNext, this::nativeEntriesIterFree, this.dbAccess, this.modCounter, entry -> entry.toMapEntry((MapEntryInternal)entry, this.keySerializer, this.valueSerializer));
    }

    private native long nativeCreateEntriesIter(long var1);

    private native MapEntryInternal nativeEntriesIterNext(long var1);

    private native void nativeEntriesIterFree(long var1);

    @Override
    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    private static native long nativeCreate(String var0, @Nullable byte[] var1, long var2);

    private native boolean nativeContainsKey(long var1, byte[] var3);

    private native void nativePut(long var1, byte[] var3, byte[] var4);

    private native byte[] nativeGet(long var1, byte[] var3);

    private native void nativeRemove(long var1, byte[] var3);

    private native long nativeCreateKeysIter(long var1);

    private native byte[] nativeKeysIterNext(long var1);

    private native void nativeKeysIterFree(long var1);

    private native long nativeCreateValuesIter(long var1);

    private native byte[] nativeValuesIterNext(long var1);

    private native void nativeValuesIterFree(long var1);

    private native void nativeClear(long var1);

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
    }
}

