/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.AbstractIndexProxy;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.StorageIterators;
import com.exonum.binding.core.util.LibraryLoader;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class KeySetIndexProxy<E>
extends AbstractIndexProxy
implements Iterable<E> {
    private static final int BASE_SPLITERATOR_CHARACTERISTICS = 272;
    private final CheckingSerializerDecorator<E> serializer;

    public static <E> KeySetIndexProxy<E> newInstance(IndexAddress address, AbstractAccess access, Serializer<E> serializer) {
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle setNativeHandle = KeySetIndexProxy.createNativeSet(address, access);
        return new KeySetIndexProxy<E>(setNativeHandle, address, access, s);
    }

    private static NativeHandle createNativeSet(IndexAddress address, AbstractAccess access) {
        long accessNativeHandle = access.getAccessNativeHandle();
        long handle = KeySetIndexProxy.nativeCreate(address.getName(), address.getIdInGroup().orElse(null), accessNativeHandle);
        NativeHandle setNativeHandle = new NativeHandle(handle);
        Cleaner cleaner = access.getCleaner();
        ProxyDestructor.newRegistered(cleaner, setNativeHandle, KeySetIndexProxy.class, KeySetIndexProxy::nativeFree);
        return setNativeHandle;
    }

    private KeySetIndexProxy(NativeHandle nativeHandle, IndexAddress address, AbstractAccess access, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, address, access);
        this.serializer = serializer;
    }

    public void add(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeAdd(this.getNativeHandle(), dbElement);
    }

    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    public boolean contains(E e) {
        byte[] dbElement = this.serializer.toBytes(e);
        return this.nativeContains(this.getNativeHandle(), dbElement);
    }

    @Override
    public Iterator<E> iterator() {
        return StorageIterators.createIterator(this.nativeCreateIterator(this.getNativeHandle()), this::nativeIteratorNext, this::nativeIteratorFree, this.dbAccess, this.modCounter, arg_0 -> this.serializer.fromBytes(arg_0));
    }

    public Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), this.streamCharacteristics()), false);
    }

    private int streamCharacteristics() {
        if (this.dbAccess.canModify()) {
            return 272;
        }
        return 1296;
    }

    public void remove(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeRemove(this.getNativeHandle(), dbElement);
    }

    private static native long nativeCreate(String var0, @Nullable byte[] var1, long var2);

    private native void nativeAdd(long var1, byte[] var3);

    private native void nativeClear(long var1);

    private native boolean nativeContains(long var1, byte[] var3);

    private native long nativeCreateIterator(long var1);

    private native byte[] nativeIteratorNext(long var1);

    private native void nativeIteratorFree(long var1);

    private native void nativeRemove(long var1, byte[] var3);

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
    }
}

