/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.indices.AbstractIndexProxy;
import com.exonum.binding.core.storage.indices.EntryIndex;
import com.exonum.binding.core.storage.indices.IndexAddress;
import java.util.NoSuchElementException;
import java.util.Optional;

abstract class AbstractEntryIndexProxy<T>
extends AbstractIndexProxy
implements EntryIndex<T> {
    protected final CheckingSerializerDecorator<T> serializer;

    AbstractEntryIndexProxy(NativeHandle nativeHandle, IndexAddress address, AbstractAccess access, CheckingSerializerDecorator<T> serializer) {
        super(nativeHandle, address, access);
        this.serializer = serializer;
    }

    @Override
    public void set(T value) {
        this.notifyModified();
        byte[] valueBytes = this.serializer.toBytes(value);
        this.nativeSet(this.getNativeHandle(), valueBytes);
    }

    @Override
    public boolean isPresent() {
        return this.nativeIsPresent(this.getNativeHandle());
    }

    @Override
    public T get() {
        byte[] value = this.nativeGet(this.getNativeHandle());
        if (value == null) {
            throw new NoSuchElementException("No value in this entry");
        }
        return (T)this.serializer.fromBytes(value);
    }

    @Override
    public T orElse(T valueIfAbsent) {
        return this.isPresent() ? this.get() : valueIfAbsent;
    }

    @Override
    public void remove() {
        this.notifyModified();
        this.nativeRemove(this.getNativeHandle());
    }

    @Override
    public Optional<T> toOptional() {
        if (this.isPresent()) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    protected abstract void nativeSet(long var1, byte[] var3);

    protected abstract boolean nativeIsPresent(long var1);

    protected abstract byte[] nativeGet(long var1);

    protected abstract byte[] nativeGetIndexHash(long var1);

    protected abstract void nativeRemove(long var1);
}

