/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.google.common.base.Preconditions;

public final class Snapshot
extends AbstractAccess {
    private final Cleaner cleaner;

    public static Snapshot newInstance(long nativeHandle, Cleaner cleaner) {
        return Snapshot.newInstance(nativeHandle, true, cleaner);
    }

    public static Snapshot newInstance(long nativeHandle, boolean owningHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner, (Object)"cleaner");
        NativeHandle h = new NativeHandle(nativeHandle);
        ProxyDestructor.newRegistered(cleaner, h, Snapshot.class, nh -> {
            if (owningHandle) {
                AbstractAccess.nativeFree(nh);
            }
        });
        return new Snapshot(h, cleaner);
    }

    private Snapshot(NativeHandle nativeHandle, Cleaner cleaner) {
        super(nativeHandle, false);
        this.cleaner = cleaner;
    }

    @Override
    public Cleaner getCleaner() {
        return this.cleaner;
    }
}

