/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public final class RoErasedAccess
extends AbstractAccess {
    private final Cleaner cleaner;

    private RoErasedAccess(NativeHandle nativeHandle, Cleaner cleaner) {
        super(nativeHandle, false);
        this.cleaner = cleaner;
    }

    public static RoErasedAccess fromHandle(long nativeHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner);
        return RoErasedAccess.fromHandleInternal(nativeHandle, cleaner);
    }

    @VisibleForTesting
    static RoErasedAccess fromRawAccess(AbstractAccess access) {
        long baseForkHandle = access.getAccessNativeHandle();
        long roForkHandle = RoErasedAccess.nativeAsReadonly(baseForkHandle);
        return RoErasedAccess.fromHandleInternal(roForkHandle, access.getCleaner());
    }

    private static native long nativeAsReadonly(long var0);

    private static RoErasedAccess fromHandleInternal(long erasedNativeHandle, Cleaner cleaner) {
        NativeHandle handle = new NativeHandle(erasedNativeHandle);
        ProxyDestructor.newRegistered(cleaner, handle, RoErasedAccess.class, AbstractAccess::nativeFree);
        return new RoErasedAccess(handle, cleaner);
    }

    @Override
    public Cleaner getCleaner() {
        return this.cleaner;
    }

    static {
        LibraryLoader.load();
    }
}

