/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.storage.database.OpenIndexRegistry;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public final class Prefixed
extends AbstractAccess {
    private final Cleaner cleaner;

    private Prefixed(NativeHandle prefixedNativeHandle, boolean canModify, Cleaner cleaner, OpenIndexRegistry registry) {
        super(prefixedNativeHandle, canModify, registry);
        this.cleaner = cleaner;
    }

    @VisibleForTesting
    static Prefixed fromAccess(String namespace, AbstractAccess baseAccess) {
        Cleaner cleaner = baseAccess.getCleaner();
        OpenIndexRegistry registry = baseAccess.getOpenIndexes();
        long handle = Prefixed.nativeCreate(namespace, baseAccess.getAccessNativeHandle());
        return Prefixed.fromHandleInternal(handle, cleaner, registry);
    }

    private static native long nativeCreate(String var0, long var1);

    public static Prefixed fromHandle(long prefixedNativeHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner);
        OpenIndexRegistry registry = new OpenIndexRegistry();
        return Prefixed.fromHandleInternal(prefixedNativeHandle, cleaner, registry);
    }

    private static Prefixed fromHandleInternal(long prefixedNativeHandle, Cleaner cleaner, OpenIndexRegistry registry) {
        NativeHandle handle = new NativeHandle(prefixedNativeHandle);
        ProxyDestructor.newRegistered(cleaner, handle, Prefixed.class, AbstractAccess::nativeFree);
        boolean canModify = Prefixed.nativeCanModify(prefixedNativeHandle);
        return new Prefixed(handle, canModify, cleaner, registry);
    }

    @Override
    public Cleaner getCleaner() {
        return this.cleaner;
    }

    static {
        LibraryLoader.load();
    }
}

