/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.storage.indices.StorageIndex;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class OpenIndexRegistry {
    private final Map<Long, StorageIndex> indexes = new HashMap<Long, StorageIndex>();

    OpenIndexRegistry() {
    }

    void registerIndex(Long id, StorageIndex index) {
        StorageIndex present = this.indexes.putIfAbsent(id, index);
        Preconditions.checkArgument((present == null ? 1 : 0) != 0, (String)"Cannot register index (%s): the id (%s) is already associated with index (%s): ", (Object)index, (Object)id, (Object)present);
    }

    Optional<StorageIndex> findIndex(Long id) {
        return Optional.ofNullable(this.indexes.get(id));
    }

    void clear() {
        this.indexes.clear();
    }
}

