/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.proxy.AbstractNativeProxy;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.storage.database.Access;
import com.exonum.binding.core.storage.database.OpenIndexRegistry;
import com.exonum.binding.core.storage.indices.EntryIndex;
import com.exonum.binding.core.storage.indices.EntryIndexProxy;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.KeySetIndexProxy;
import com.exonum.binding.core.storage.indices.ListIndexProxy;
import com.exonum.binding.core.storage.indices.MapIndexProxy;
import com.exonum.binding.core.storage.indices.ProofEntryIndex;
import com.exonum.binding.core.storage.indices.ProofEntryIndexProxy;
import com.exonum.binding.core.storage.indices.ProofListIndexProxy;
import com.exonum.binding.core.storage.indices.ProofMapIndexProxy;
import com.exonum.binding.core.storage.indices.StorageIndex;
import com.exonum.binding.core.storage.indices.ValueSetIndexProxy;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class AbstractAccess
extends AbstractNativeProxy
implements Access {
    private static final long UNKNOWN_INDEX_ID = 0L;
    private final OpenIndexRegistry indexRegistry;
    private final boolean canModify;

    AbstractAccess(NativeHandle nativeHandle, boolean canModify) {
        this(nativeHandle, canModify, new OpenIndexRegistry());
    }

    AbstractAccess(NativeHandle nativeHandle, boolean canModify, OpenIndexRegistry registry) {
        super(nativeHandle);
        this.canModify = canModify;
        this.indexRegistry = registry;
    }

    @Override
    public <E> ProofListIndexProxy<E> getProofList(IndexAddress address, Serializer<E> serializer) {
        return this.findOrCreate(address, ProofListIndexProxy.class, () -> ProofListIndexProxy.newInstance(address, this, serializer));
    }

    @Override
    public <E> ListIndexProxy<E> getList(IndexAddress address, Serializer<E> serializer) {
        return this.findOrCreate(address, ListIndexProxy.class, () -> ListIndexProxy.newInstance(address, this, serializer));
    }

    @Override
    public <K, V> ProofMapIndexProxy<K, V> getProofMap(IndexAddress address, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.findOrCreate(address, ProofMapIndexProxy.class, () -> ProofMapIndexProxy.newInstance(address, this, keySerializer, valueSerializer));
    }

    @Override
    public <K, V> ProofMapIndexProxy<K, V> getRawProofMap(IndexAddress address, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.findOrCreate(address, ProofMapIndexProxy.class, () -> ProofMapIndexProxy.newInstanceNoKeyHashing(address, this, keySerializer, valueSerializer));
    }

    @Override
    public <K, V> MapIndexProxy<K, V> getMap(IndexAddress address, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.findOrCreate(address, MapIndexProxy.class, () -> MapIndexProxy.newInstance(address, this, keySerializer, valueSerializer));
    }

    @Override
    public <E> KeySetIndexProxy<E> getKeySet(IndexAddress address, Serializer<E> serializer) {
        return this.findOrCreate(address, KeySetIndexProxy.class, () -> KeySetIndexProxy.newInstance(address, this, serializer));
    }

    @Override
    public <E> ValueSetIndexProxy<E> getValueSet(IndexAddress address, Serializer<E> serializer) {
        return this.findOrCreate(address, ValueSetIndexProxy.class, () -> ValueSetIndexProxy.newInstance(address, this, serializer));
    }

    @Override
    public <E> ProofEntryIndex<E> getProofEntry(IndexAddress address, Serializer<E> serializer) {
        return this.findOrCreate(address, ProofEntryIndexProxy.class, () -> ProofEntryIndexProxy.newInstance(address, this, serializer));
    }

    @Override
    public <E> EntryIndex<E> getEntry(IndexAddress address, Serializer<E> serializer) {
        return this.findOrCreate(address, EntryIndexProxy.class, () -> EntryIndexProxy.newInstance(address, this, serializer));
    }

    private <T extends StorageIndex> T findOrCreate(IndexAddress address, Class<T> indexType, Supplier<T> indexSupplier) {
        return (T)this.findOpenIndex(address, indexType).orElseGet(() -> this.createIndex(indexSupplier));
    }

    private <T extends StorageIndex> Optional<T> findOpenIndex(IndexAddress address, Class<T> indexType) {
        OptionalLong indexId = this.findIndexId(address);
        if (indexId.isPresent()) {
            return this.indexRegistry.findIndex(indexId.getAsLong()).map(index -> AbstractAccess.checkedCast(index, indexType));
        }
        return Optional.empty();
    }

    private static <IndexT extends StorageIndex> IndexT checkedCast(StorageIndex cachedIndex, Class<IndexT> requestedIndexType) {
        Preconditions.checkArgument((boolean)requestedIndexType.isInstance(cachedIndex), (String)"Cannot create index of type %s: the index with such address (%s) was already createdof another type (%s)", requestedIndexType, (Object)cachedIndex.getAddress(), (Object)cachedIndex);
        return (IndexT)((StorageIndex)requestedIndexType.cast(cachedIndex));
    }

    private <T extends StorageIndex> T createIndex(Supplier<T> indexSupplier) {
        StorageIndex newIndex = (StorageIndex)indexSupplier.get();
        OptionalLong indexId = this.findIndexId(newIndex.getAddress());
        indexId.ifPresent(id -> this.registerIndex(id, newIndex));
        return (T)newIndex;
    }

    private OptionalLong findIndexId(IndexAddress address) {
        long id = this.findIndexId(address.getName(), address.getIdInGroup().orElse(null));
        if (id == 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(id);
    }

    private long findIndexId(String name, @Nullable byte[] idInGroup) {
        return AbstractAccess.nativeFindIndexId(this.getNativeHandle(), name, idInGroup);
    }

    private void registerIndex(Long id, StorageIndex index) {
        this.indexRegistry.registerIndex(id, index);
    }

    void clearOpenIndexes() {
        this.indexRegistry.clear();
    }

    @Override
    public boolean canModify() {
        return this.canModify;
    }

    @Override
    public long getAccessNativeHandle() {
        return super.getNativeHandle();
    }

    protected OpenIndexRegistry getOpenIndexes() {
        return this.indexRegistry;
    }

    public abstract Cleaner getCleaner();

    private static native long nativeFindIndexId(long var0, String var2, @Nullable byte[] var3);

    protected static native boolean nativeCanModify(long var0);

    protected static native void nativeFree(long var0);
}

