/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.service;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.blockchain.BlockchainData;
import com.exonum.binding.core.service.InternalExecutionContext;
import com.exonum.binding.core.storage.database.Prefixed;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;

public interface ExecutionContext {
    default public Prefixed getServiceData() {
        return this.getBlockchainData().getExecutingServiceData();
    }

    public BlockchainData getBlockchainData();

    public Optional<HashCode> getTransactionMessageHash();

    public Optional<PublicKey> getAuthorPk();

    public String getServiceName();

    public int getServiceId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BlockchainData blockchainData;
        private HashCode hash;
        private PublicKey authorPk;
        private String serviceName;
        private Integer serviceId;

        public Builder blockchainData(BlockchainData blockchainData) {
            this.blockchainData = blockchainData;
            return this;
        }

        public Builder txMessageHash(@Nullable HashCode hash) {
            this.hash = hash;
            return this;
        }

        public Builder authorPk(@Nullable PublicKey authorPk) {
            this.authorPk = authorPk;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder serviceId(int serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public ExecutionContext build() {
            return InternalExecutionContext.newInstance(this.blockchainData, this.hash, this.authorPk, this.serviceName, (Integer)Preconditions.checkNotNull((Object)this.serviceId));
        }

        private Builder() {
        }
    }
}

