/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.runtime.UnexpectedExecutionException;
import com.exonum.binding.core.service.ExecutionContext;
import com.exonum.binding.core.service.ExecutionException;
import com.exonum.binding.core.service.Service;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.WrongMethodTypeException;

class TransactionMethod {
    private final MethodHandle methodHandle;
    private final Serializer<?> argumentsSerializer;

    TransactionMethod(MethodHandle methodHandle, Serializer<?> argumentsSerializer) {
        this.methodHandle = methodHandle;
        this.argumentsSerializer = argumentsSerializer;
    }

    void invoke(Service targetService, byte[] arguments, ExecutionContext context) {
        Object argumentsObject = this.serializeArguments(arguments);
        try {
            this.methodHandle.invoke(targetService, argumentsObject, context);
        }
        catch (ClassCastException | WrongMethodTypeException invocationException) {
            throw invocationException;
        }
        catch (ExecutionException serviceException) {
            throw serviceException;
        }
        catch (Throwable unexpectedServiceException) {
            throw new UnexpectedExecutionException(unexpectedServiceException);
        }
    }

    private Object serializeArguments(byte[] arguments) {
        return this.argumentsSerializer.fromBytes(arguments);
    }
}

