/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.TransactionExtractor;
import com.exonum.binding.core.runtime.TransactionMethod;
import com.exonum.binding.core.service.ExecutionContext;
import com.exonum.binding.core.service.Service;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;

final class TransactionInvoker {
    private final Service service;
    private final Map<Integer, TransactionMethod> transactionMethods;

    @Inject
    TransactionInvoker(Service service) {
        this.service = service;
        this.transactionMethods = TransactionExtractor.extractTransactionMethods(service.getClass());
    }

    void invokeTransaction(int transactionId, byte[] arguments, ExecutionContext context) {
        Preconditions.checkArgument((boolean)this.transactionMethods.containsKey(transactionId), (String)"No method with transaction id (%s)", (int)transactionId);
        TransactionMethod transactionMethod = this.transactionMethods.get(transactionId);
        transactionMethod.invoke(this.service, arguments, context);
    }
}

