/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.runtime.TransactionMethod;
import com.exonum.binding.core.service.ExecutionContext;
import com.exonum.binding.core.transaction.Transaction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

final class TransactionExtractor {
    static Map<Integer, TransactionMethod> extractTransactionMethods(Class<?> serviceClass) {
        Map<Integer, Method> transactionMethods = TransactionExtractor.findTransactionMethods(serviceClass);
        MethodHandles.Lookup lookup = MethodHandles.publicLookup().in(serviceClass);
        return transactionMethods.entrySet().stream().peek(tx -> TransactionExtractor.validateTransactionMethod((Method)tx.getValue(), serviceClass)).collect(Collectors.toMap(Map.Entry::getKey, e -> TransactionExtractor.toTransactionMethod((Method)e.getValue(), lookup)));
    }

    @VisibleForTesting
    static Map<Integer, Method> findTransactionMethods(Class<?> serviceClass) {
        HashMap<Integer, Method> transactionMethods = new HashMap<Integer, Method>();
        while (serviceClass != Object.class) {
            Method[] classMethods;
            for (Method method : classMethods = serviceClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Transaction.class)) continue;
                Transaction annotation = method.getAnnotation(Transaction.class);
                int transactionId = annotation.value();
                TransactionExtractor.checkDuplicates(transactionMethods, transactionId, serviceClass, method);
                transactionMethods.put(transactionId, method);
            }
            serviceClass = serviceClass.getSuperclass();
        }
        return transactionMethods;
    }

    private static void checkDuplicates(Map<Integer, Method> transactionMethods, int transactionId, Class<?> serviceClass, Method method) {
        if (transactionMethods.containsKey(transactionId)) {
            String firstMethodName = transactionMethods.get(transactionId).getName();
            String errorMessage = String.format("Service %s has more than one transaction with the same id (%s): first: %s; second: %s", serviceClass.getName(), transactionId, firstMethodName, method.getName());
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void validateTransactionMethod(Method transaction, Class<?> serviceClass) {
        String errorMessage = String.format("Method %s in a service class %s annotated with @Transaction should have precisely two parameters: transaction arguments of 'byte[]' type or a protobuf type and transaction context of 'com.exonum.binding.core.transaction.TransactionContext' type.", transaction.getName(), serviceClass.getName());
        Preconditions.checkArgument((transaction.getParameterCount() == 2 ? 1 : 0) != 0, (Object)errorMessage);
        Class<?> firstParameter = transaction.getParameterTypes()[0];
        Class<?> secondParameter = transaction.getParameterTypes()[1];
        Preconditions.checkArgument((firstParameter == byte[].class || TransactionExtractor.isProtobufArgument(firstParameter) ? 1 : 0) != 0, (Object)String.format(errorMessage + " But first parameter type was: %s", firstParameter.getName()));
        Preconditions.checkArgument((boolean)ExecutionContext.class.isAssignableFrom(secondParameter), (Object)String.format(errorMessage + " But second parameter type was: %s", secondParameter.getName()));
    }

    private static TransactionMethod toTransactionMethod(Method method, MethodHandles.Lookup lookup) {
        MethodHandle methodHandle;
        Serializer argumentsSerializer = StandardSerializers.bytes();
        Class<?> parameterType = method.getParameterTypes()[0];
        if (TransactionExtractor.isProtobufArgument(parameterType)) {
            argumentsSerializer = StandardSerializers.protobuf(parameterType);
        }
        try {
            methodHandle = lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Couldn't access method %s", method.getName()), e);
        }
        return new TransactionMethod(methodHandle, argumentsSerializer);
    }

    private static boolean isProtobufArgument(Class type) {
        return MessageLite.class.isAssignableFrom(type);
    }

    private TransactionExtractor() {
    }
}

