/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.ServiceConfiguration;
import com.exonum.binding.core.runtime.ServiceInstanceSpec;
import com.exonum.binding.core.runtime.TransactionInvoker;
import com.exonum.binding.core.runtime.UnexpectedExecutionException;
import com.exonum.binding.core.service.BlockCommittedEvent;
import com.exonum.binding.core.service.Configurable;
import com.exonum.binding.core.service.Configuration;
import com.exonum.binding.core.service.ExecutionContext;
import com.exonum.binding.core.service.ExecutionException;
import com.exonum.binding.core.service.Node;
import com.exonum.binding.core.service.Service;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.net.UrlEscapers;
import com.google.inject.Inject;
import io.vertx.ext.web.Router;

final class ServiceWrapper {
    static final String DEFAULT_INTERFACE_NAME = "";
    static final int SUPERVISOR_SERVICE_ID = 0;
    @VisibleForTesting
    static final String CONFIGURE_INTERFACE_NAME = "exonum.Configure";
    @VisibleForTesting
    static final int VERIFY_CONFIGURATION_TX_ID = 0;
    @VisibleForTesting
    static final int APPLY_CONFIGURATION_TX_ID = 1;
    private final Service service;
    private final ServiceInstanceSpec instanceSpec;
    private final TransactionInvoker invoker;
    private final Node node;

    @Inject
    ServiceWrapper(Service service, ServiceInstanceSpec instanceSpec, TransactionInvoker transactionInvoker, Node node) {
        this.service = service;
        this.instanceSpec = instanceSpec;
        this.invoker = transactionInvoker;
        this.node = node;
    }

    Service getService() {
        return this.service;
    }

    String getName() {
        return this.instanceSpec.getName();
    }

    int getId() {
        return this.instanceSpec.getId();
    }

    void initialize(ExecutionContext context, Configuration configuration) {
        ServiceWrapper.callServiceMethod(() -> this.service.initialize(context, configuration));
    }

    void resume(ExecutionContext context, byte[] arguments) {
        ServiceWrapper.callServiceMethod(() -> this.service.resume(context, arguments));
    }

    void executeTransaction(String interfaceName, int txId, byte[] arguments, int callerServiceId, ExecutionContext context) {
        switch (interfaceName) {
            case "": {
                this.executeIntrinsicTransaction(txId, arguments, context);
                break;
            }
            case "exonum.Configure": {
                this.executeConfigurableTransaction(txId, arguments, callerServiceId, context);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown interface (name=%s, txId=%d)", interfaceName, txId));
            }
        }
    }

    private void executeIntrinsicTransaction(int txId, byte[] arguments, ExecutionContext context) {
        this.invoker.invokeTransaction(txId, arguments, context);
    }

    private void executeConfigurableTransaction(int txId, byte[] arguments, int callerServiceId, ExecutionContext context) {
        Preconditions.checkArgument((boolean)(this.service instanceof Configurable), (String)"Service (%s) doesn't implement Configurable", (Object)this.getName());
        Preconditions.checkArgument((callerServiceId == 0 ? 1 : 0) != 0, (String)"Invalid caller service id (%s). Operations in Configurable interface may only be invoked by the supervisor service (%s)", (int)callerServiceId, (int)0);
        Configurable configurable = (Configurable)((Object)this.service);
        ServiceConfiguration config = new ServiceConfiguration(arguments);
        switch (txId) {
            case 0: {
                ServiceWrapper.callServiceMethod(() -> configurable.verifyConfiguration(context, config));
                break;
            }
            case 1: {
                ServiceWrapper.callServiceMethod(() -> configurable.applyConfiguration(context, config));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown txId (%d) in Configurable interface", txId));
            }
        }
    }

    void beforeTransactions(ExecutionContext context) {
        ServiceWrapper.callServiceMethod(() -> this.service.beforeTransactions(context));
    }

    void afterTransactions(ExecutionContext context) {
        ServiceWrapper.callServiceMethod(() -> this.service.afterTransactions(context));
    }

    private static void callServiceMethod(Runnable serviceMethod) {
        try {
            serviceMethod.run();
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, ExecutionException.class);
            throw new UnexpectedExecutionException(e);
        }
    }

    void afterCommit(BlockCommittedEvent event) {
        this.service.afterCommit(event);
    }

    void createPublicApiHandlers(Router router) {
        this.service.createPublicApiHandlers(this.node, router);
    }

    String getPublicApiRelativePath() {
        return UrlEscapers.urlPathSegmentEscaper().escape(this.getName());
    }

    void requestToStop() {
        this.node.close();
    }
}

