/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.messages.DeployArguments;
import com.exonum.binding.common.runtime.ServiceArtifactId;
import com.exonum.binding.core.blockchain.BlockchainData;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.CloseFailuresException;
import com.exonum.binding.core.runtime.AccessFactory;
import com.exonum.binding.core.runtime.NodeProxy;
import com.exonum.binding.core.runtime.ServiceInstanceSpec;
import com.exonum.binding.core.runtime.ServiceLoadingException;
import com.exonum.binding.core.runtime.ServiceRuntime;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.messages.core.runtime.Base;
import com.exonum.messages.core.runtime.Lifecycle;
import com.google.inject.Inject;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.OptionalInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceRuntimeAdapter {
    private final ServiceRuntime serviceRuntime;
    private final AccessFactory accessFactory;
    private static final Logger logger = LogManager.getLogger(ServiceRuntimeAdapter.class);

    @Inject
    public ServiceRuntimeAdapter(ServiceRuntime serviceRuntime, AccessFactory accessFactory) {
        this.serviceRuntime = serviceRuntime;
        this.accessFactory = accessFactory;
    }

    public ServiceRuntime getServiceRuntime() {
        return this.serviceRuntime;
    }

    void initialize(long nodeNativeHandle) {
        NodeProxy node = new NodeProxy(nodeNativeHandle);
        this.serviceRuntime.initialize(node);
    }

    void deployArtifact(byte[] artifactId, byte[] deploySpec) throws ServiceLoadingException {
        Base.ArtifactId artifact = ServiceRuntimeAdapter.parseArtifact(artifactId);
        ServiceArtifactId javaArtifactId = ServiceArtifactId.fromProto((Base.ArtifactId)artifact);
        DeployArguments deployArguments = ServiceRuntimeAdapter.parseDeployArgs(javaArtifactId, deploySpec);
        String artifactFilename = deployArguments.getArtifactFilename();
        this.serviceRuntime.deployArtifact(javaArtifactId, artifactFilename);
    }

    boolean isArtifactDeployed(byte[] artifactId) {
        Base.ArtifactId artifact = ServiceRuntimeAdapter.parseArtifact(artifactId);
        ServiceArtifactId serviceArtifact = ServiceArtifactId.newJavaId((String)artifact.getName(), (String)artifact.getVersion());
        return this.serviceRuntime.isArtifactDeployed(serviceArtifact);
    }

    private static DeployArguments parseDeployArgs(ServiceArtifactId artifact, byte[] deploySpec) {
        try {
            return DeployArguments.parseFrom((byte[])deploySpec);
        }
        catch (InvalidProtocolBufferException e) {
            String message = "Invalid deploy specification for artifact " + artifact;
            logger.error(message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
    }

    private static Base.ArtifactId parseArtifact(byte[] artifactId) {
        try {
            return Base.ArtifactId.parseFrom((byte[])artifactId);
        }
        catch (InvalidProtocolBufferException e) {
            String message = "Invalid artifact";
            logger.error(message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
    }

    void initiateAddingService(long bdNativeHandle, byte[] instanceSpec, byte[] configuration) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner();){
            BlockchainData blockchainData = this.accessFactory.createBlockchainData(bdNativeHandle, cleaner);
            ServiceInstanceSpec javaInstanceSpec = ServiceRuntimeAdapter.parseInstanceSpec(instanceSpec);
            this.serviceRuntime.initiateAddingService(blockchainData, javaInstanceSpec, configuration);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void initiateResumingService(long bdHandle, byte[] instanceSpec, byte[] arguments) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner();){
            BlockchainData blockchainData = this.accessFactory.createBlockchainData(bdHandle, cleaner);
            ServiceInstanceSpec javaInstanceSpec = ServiceRuntimeAdapter.parseInstanceSpec(instanceSpec);
            this.serviceRuntime.initiateResumingService(blockchainData, javaInstanceSpec, arguments);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void updateServiceStatus(byte[] instanceSpec, byte[] instanceStatus) {
        ServiceInstanceSpec javaInstanceSpec = ServiceRuntimeAdapter.parseInstanceSpec(instanceSpec);
        Lifecycle.InstanceStatus status = ServiceRuntimeAdapter.parseInstanceStatus(instanceStatus);
        this.serviceRuntime.updateInstanceStatus(javaInstanceSpec, status);
    }

    private static ServiceInstanceSpec parseInstanceSpec(byte[] instanceSpec) {
        try {
            Base.InstanceSpec spec = Base.InstanceSpec.parseFrom((byte[])instanceSpec);
            Base.ArtifactId artifact = spec.getArtifact();
            ServiceArtifactId artifactId = ServiceArtifactId.fromProto((Base.ArtifactId)artifact);
            return ServiceInstanceSpec.newInstance(spec.getName(), spec.getId(), artifactId);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    private static Lifecycle.InstanceStatus parseInstanceStatus(byte[] instanceStatus) {
        try {
            return Lifecycle.InstanceStatus.parseFrom((byte[])instanceStatus);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    void executeTransaction(int serviceId, String interfaceName, int txId, byte[] arguments, long bdNativeHandle, int callerServiceId, byte[] txMessageHash, byte[] authorPublicKey) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("executeTransaction");){
            BlockchainData blockchainData = this.accessFactory.createBlockchainData(bdNativeHandle, cleaner);
            HashCode hash = HashCode.fromBytes((byte[])txMessageHash);
            PublicKey authorPk = PublicKey.fromBytes((byte[])authorPublicKey);
            this.serviceRuntime.executeTransaction(serviceId, interfaceName, txId, arguments, blockchainData, callerServiceId, hash, authorPk);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void beforeTransactions(int serviceId, long bdNativeHandle) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("beforeTransactions");){
            BlockchainData blockchainData = this.accessFactory.createBlockchainData(bdNativeHandle, cleaner);
            this.serviceRuntime.beforeTransactions(serviceId, blockchainData);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void afterTransactions(int serviceId, long bdNativeHandle) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("afterTransactions");){
            BlockchainData blockchainData = this.accessFactory.createBlockchainData(bdNativeHandle, cleaner);
            this.serviceRuntime.afterTransactions(serviceId, blockchainData);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void afterCommit(long snapshotHandle, int validatorId, long height) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("afterCommit");){
            Snapshot snapshot = this.accessFactory.createSnapshot(snapshotHandle, cleaner);
            OptionalInt optionalValidatorId = validatorId >= 0 ? OptionalInt.of(validatorId) : OptionalInt.empty();
            this.serviceRuntime.afterCommit(snapshot, optionalValidatorId, height);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void shutdown() throws InterruptedException {
        this.serviceRuntime.shutdown();
    }

    private static void handleCloseFailure(CloseFailuresException e) throws CloseFailuresException {
        logger.error("Failed to close some resources", (Throwable)e);
        throw e;
    }
}

