/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.runtime.ServiceArtifactId;
import com.exonum.binding.core.blockchain.BlockchainData;
import com.exonum.binding.core.runtime.BlockchainDataFactory;
import com.exonum.binding.core.runtime.LoadedServiceDefinition;
import com.exonum.binding.core.runtime.NodeProxy;
import com.exonum.binding.core.runtime.RuntimeTransport;
import com.exonum.binding.core.runtime.ServiceConfiguration;
import com.exonum.binding.core.runtime.ServiceInstanceSpec;
import com.exonum.binding.core.runtime.ServiceLoader;
import com.exonum.binding.core.runtime.ServiceLoadingException;
import com.exonum.binding.core.runtime.ServiceNodeProxy;
import com.exonum.binding.core.runtime.ServiceWrapper;
import com.exonum.binding.core.runtime.ServicesFactory;
import com.exonum.binding.core.service.BlockCommittedEventImpl;
import com.exonum.binding.core.service.ExecutionContext;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.messages.core.runtime.Lifecycle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public final class ServiceRuntime
implements AutoCloseable {
    @VisibleForTesting
    static final String API_ROOT_PATH = "/api/services";
    private static final Logger logger = LogManager.getLogger(ServiceRuntime.class);
    private final ServiceLoader serviceLoader;
    private final ServicesFactory servicesFactory;
    private final RuntimeTransport runtimeTransport;
    private final BlockchainDataFactory blockchainDataFactory;
    private final Path artifactsDir;
    private final SortedMap<String, ServiceWrapper> services = new TreeMap<String, ServiceWrapper>();
    private final Map<Integer, ServiceWrapper> servicesById = new HashMap<Integer, ServiceWrapper>();
    private final Object lock = new Object();
    private NodeProxy nodeProxy;

    @Inject
    public ServiceRuntime(ServiceLoader serviceLoader, ServicesFactory servicesFactory, RuntimeTransport runtimeTransport, BlockchainDataFactory blockchainDataFactory, @Named(value="ServiceRuntime artifacts dir") Path artifactsDir) {
        this.serviceLoader = (ServiceLoader)Preconditions.checkNotNull((Object)serviceLoader);
        this.servicesFactory = (ServicesFactory)Preconditions.checkNotNull((Object)servicesFactory);
        this.runtimeTransport = (RuntimeTransport)Preconditions.checkNotNull((Object)runtimeTransport);
        this.blockchainDataFactory = blockchainDataFactory;
        this.artifactsDir = (Path)Preconditions.checkNotNull((Object)artifactsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(NodeProxy node) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.nodeProxy == null ? 1 : 0) != 0, (String)"Invalid attempt to replace already set node (%s) with %s", (Object)this.nodeProxy, (Object)node);
            this.nodeProxy = (NodeProxy)Preconditions.checkNotNull((Object)node);
            this.runtimeTransport.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployArtifact(ServiceArtifactId id, String filename) throws ServiceLoadingException {
        try {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkState((boolean)Files.isDirectory(this.artifactsDir, new LinkOption[0]), (String)"Artifacts dir (%s) does not exist or is not a directory: check the runtime configuration", (Object)this.artifactsDir);
                Path artifactLocation = this.artifactsDir.resolve(filename);
                LoadedServiceDefinition loadedServiceDefinition = this.serviceLoader.loadService(artifactLocation);
                ServiceArtifactId actualId = loadedServiceDefinition.getId();
                if (!actualId.equals(id)) {
                    this.serviceLoader.unloadService(actualId);
                    throw new ServiceLoadingException(String.format("The artifact loaded from (%s) has wrong id (%s) in metadata. Expected id: %s", filename, actualId, id));
                }
            }
            logger.info("Loaded an artifact ({}) from {}", (Object)id, (Object)filename);
        }
        catch (Throwable e) {
            logger.error("Failed to load an artifact {} from {}", (Object)id, (Object)filename, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isArtifactDeployed(ServiceArtifactId id) {
        Object object = this.lock;
        synchronized (object) {
            return this.serviceLoader.findService(id).isPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateAddingService(BlockchainData blockchainData, ServiceInstanceSpec instanceSpec, byte[] configuration) {
        try {
            Object object = this.lock;
            synchronized (object) {
                ServiceWrapper service = this.createServiceInstance(instanceSpec);
                ExecutionContext context = ServiceRuntime.newContext(service, blockchainData).build();
                service.initialize(context, new ServiceConfiguration(configuration));
            }
            logger.info("Initialized a new service: {}", (Object)instanceSpec);
        }
        catch (Exception e) {
            logger.error("Failed to initialize a service {} instance with parameters {}", (Object)instanceSpec, (Object)configuration, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateResumingService(BlockchainData blockchainData, ServiceInstanceSpec instanceSpec, byte[] arguments) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.checkStoppedService(instanceSpec.getId());
                ServiceWrapper service = this.createServiceInstance(instanceSpec);
                ExecutionContext context = ServiceRuntime.newContext(service, blockchainData).build();
                service.resume(context, arguments);
            }
            logger.info("Resumed service: {}", (Object)instanceSpec);
        }
        catch (Exception e) {
            logger.error("Failed to resume a service {} instance with parameters {}", (Object)instanceSpec, (Object)arguments, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInstanceStatus(ServiceInstanceSpec instanceSpec, Lifecycle.InstanceStatus instanceStatus) {
        Object object = this.lock;
        synchronized (object) {
            Lifecycle.InstanceStatus.Simple status = instanceStatus.getSimple();
            switch (status) {
                case ACTIVE: {
                    this.activateService(instanceSpec);
                    break;
                }
                case STOPPED: {
                    this.stopService(instanceSpec);
                    break;
                }
                default: {
                    String msg = String.format("Unexpected status %s received for the service %s", status, instanceSpec.getName());
                    logger.error(msg);
                    throw new IllegalArgumentException(msg);
                }
            }
        }
    }

    private void activateService(ServiceInstanceSpec instanceSpec) {
        try {
            ServiceWrapper service = this.createServiceInstance(instanceSpec);
            this.registerService(service);
            this.connectServiceApi(service);
            logger.info("Activated a service: {}", (Object)instanceSpec);
        }
        catch (Exception e) {
            logger.error("Failed to activate a service {} instance", (Object)instanceSpec, (Object)e);
            throw e;
        }
    }

    private void stopService(ServiceInstanceSpec instanceSpec) {
        String name = instanceSpec.getName();
        Optional<ServiceWrapper> activeService = this.findService(name);
        if (activeService.isPresent()) {
            ServiceWrapper service = activeService.get();
            service.requestToStop();
            this.runtimeTransport.disconnectServiceApi(service);
            this.unRegisterService(service);
            logger.info("Stopped a service: {}", (Object)instanceSpec);
        } else {
            logger.warn("There is no active service with the given name {}. Possibly restoring services state after reboot?", (Object)name);
        }
    }

    private ServiceWrapper createServiceInstance(ServiceInstanceSpec instanceSpec) {
        String name = instanceSpec.getName();
        Preconditions.checkArgument((boolean)this.findService(name).isEmpty(), (String)"Service with name '%s' already created: %s", (Object)name, this.services.get(name));
        ServiceArtifactId artifactId = instanceSpec.getArtifactId();
        LoadedServiceDefinition serviceDefinition = this.serviceLoader.findService(artifactId).orElseThrow(() -> new IllegalArgumentException("Unknown artifactId: " + artifactId));
        ServiceNodeProxy serviceNode = new ServiceNodeProxy(this.nodeProxy, this.blockchainDataFactory, name);
        return this.servicesFactory.createService(serviceDefinition, instanceSpec, serviceNode);
    }

    private void registerService(ServiceWrapper service) {
        String name = service.getName();
        this.services.put(name, service);
        int id = service.getId();
        this.servicesById.put(id, service);
    }

    private void unRegisterService(ServiceWrapper service) {
        String name = service.getName();
        this.services.remove(name);
        int id = service.getId();
        this.servicesById.remove(id);
    }

    private void connectServiceApi(ServiceWrapper service) {
        try {
            this.runtimeTransport.connectServiceApi(service);
        }
        catch (Exception e) {
            logger.error("Failed to connect service {} public API. Its HTTP handlers will likely be inaccessible", (Object)service.getName(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTransaction(int serviceId, String interfaceName, int txId, byte[] arguments, BlockchainData blockchainData, int callerServiceId, HashCode txMessageHash, PublicKey authorPublicKey) {
        Object object = this.lock;
        synchronized (object) {
            ServiceWrapper service = this.getServiceById(serviceId);
            ExecutionContext context = ServiceRuntime.newContext(service, blockchainData).txMessageHash(txMessageHash).authorPk(authorPublicKey).build();
            try {
                service.executeTransaction(interfaceName, txId, arguments, callerServiceId, context);
            }
            catch (Exception e) {
                logger.info("Transaction execution failed (service={}, txId={}, txMessageHash={})", (Object)service.getName(), (Object)txId, context.getTransactionMessageHash(), (Object)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTransactions(int serviceId, BlockchainData blockchainData) {
        Object object = this.lock;
        synchronized (object) {
            ServiceWrapper service = this.getServiceById(serviceId);
            try {
                ExecutionContext context = ServiceRuntime.newContext(service, blockchainData).build();
                service.beforeTransactions(context);
            }
            catch (Exception e) {
                logger.error("Service {} threw exception in beforeTransactions.", (Object)service.getName(), (Object)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTransactions(int serviceId, BlockchainData blockchainData) {
        Object object = this.lock;
        synchronized (object) {
            ServiceWrapper service = this.getServiceById(serviceId);
            try {
                ExecutionContext context = ServiceRuntime.newContext(service, blockchainData).build();
                service.afterTransactions(context);
            }
            catch (Exception e) {
                logger.error("Service {} threw exception in afterTransactions. Any changes will be rolled-back", (Object)service.getName(), (Object)e);
                throw e;
            }
        }
    }

    private static ExecutionContext.Builder newContext(ServiceWrapper service, BlockchainData blockchainData) {
        return ExecutionContext.builder().blockchainData(blockchainData).serviceName(service.getName()).serviceId(service.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(Snapshot snapshot, OptionalInt validatorId, long height) {
        Object object = this.lock;
        synchronized (object) {
            for (ServiceWrapper service : this.services.values()) {
                try {
                    BlockchainData blockchainData = this.blockchainDataFactory.fromRawAccess(snapshot, service.getName());
                    BlockCommittedEventImpl event = BlockCommittedEventImpl.valueOf(blockchainData, validatorId, height);
                    service.afterCommit(event);
                }
                catch (Exception e) {
                    logger.error("Service {} threw an exception in its afterCommit handler. Height={}", (Object)service.getName(), (Object)height, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            try {
                logger.info("Shutting down the runtime");
                this.stopServer();
                this.clearServices();
                this.unloadArtifacts();
                if (this.nodeProxy != null) {
                    this.nodeProxy.close();
                }
                logger.info("The runtime shutdown complete");
            }
            catch (Exception e) {
                logger.error("Shutdown failure", (Throwable)e);
                throw e;
            }
        }
    }

    private void stopServer() throws InterruptedException {
        try {
            logger.info("Requesting the HTTP server to stop");
            this.runtimeTransport.close();
            logger.info("Stopped the HTTP server");
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted before completion");
            throw e;
        }
        catch (Exception e) {
            logger.error("Exception occurred whilst stopping the server", (Throwable)e);
        }
    }

    private void clearServices() {
        this.services.clear();
        this.servicesById.clear();
    }

    private void unloadArtifacts() {
        try {
            logger.info("Unloading the artifacts");
            this.serviceLoader.unloadAll();
            logger.info("Unloaded the artifacts");
        }
        catch (IllegalStateException e) {
            logger.error("Unload failure", (Throwable)e);
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.shutdown();
    }

    private ServiceWrapper getServiceById(Integer serviceId) {
        this.checkActiveService(serviceId);
        return this.servicesById.get(serviceId);
    }

    private void checkActiveService(Integer serviceId) {
        Preconditions.checkArgument((boolean)this.servicesById.containsKey(serviceId), (String)"No service with id=%s in the Java runtime", (Object)serviceId);
    }

    private void checkStoppedService(Integer serviceId) {
        ServiceWrapper activeService = this.servicesById.get(serviceId);
        Preconditions.checkArgument((activeService == null ? 1 : 0) != 0, (String)"Service with id=%s should be stopped, but actually active. Found active service instance: %s", (Object)serviceId, (Object)activeService);
    }

    @VisibleForTesting
    Optional<ServiceWrapper> findService(String name) {
        return Optional.ofNullable((ServiceWrapper)this.services.get(name));
    }
}

