/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.blockchain.BlockchainData;
import com.exonum.binding.core.runtime.BlockchainDataFactory;
import com.exonum.binding.core.runtime.NodeProxy;
import com.exonum.binding.core.service.Node;
import com.exonum.binding.core.storage.database.AbstractAccess;
import com.exonum.binding.core.transaction.RawTransaction;
import com.google.common.base.Preconditions;
import java.util.function.Function;

class ServiceNodeProxy
implements Node {
    private final NodeProxy node;
    private final BlockchainDataFactory blockchainDataFactory;
    private final String instanceName;
    private boolean closed;

    ServiceNodeProxy(NodeProxy node, BlockchainDataFactory blockchainDataFactory, String instanceName) {
        this.node = (NodeProxy)Preconditions.checkNotNull((Object)node);
        this.blockchainDataFactory = blockchainDataFactory;
        this.instanceName = instanceName;
        this.closed = false;
    }

    @Override
    public HashCode submitTransaction(RawTransaction rawTransaction) {
        return this.node().submitTransaction(rawTransaction);
    }

    @Override
    public <ResultT> ResultT withBlockchainData(Function<BlockchainData, ResultT> snapshotFunction) {
        return this.node().withSnapshot(snapshotFunction.compose(snapshot -> this.blockchainDataFactory.fromRawAccess((AbstractAccess)snapshot, this.instanceName)));
    }

    @Override
    public PublicKey getPublicKey() {
        return this.node().getPublicKey();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private NodeProxy node() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Node access is closed");
        return this.node;
    }
}

