/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.messages.Service;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.common.serialization.json.JsonSerializer;
import com.exonum.binding.core.service.Configuration;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;

final class ServiceConfiguration
implements Configuration {
    private final byte[] configuration;

    ServiceConfiguration(byte[] configuration) {
        this.configuration = (byte[])configuration.clone();
    }

    @Override
    public <MessageT extends MessageLite> MessageT getAsMessage(Class<MessageT> parametersType) {
        Serializer serializer = StandardSerializers.protobuf(parametersType);
        return (MessageT)((MessageLite)serializer.fromBytes(this.configuration));
    }

    @Override
    public Service.ServiceConfiguration.Format getConfigurationFormat() {
        Service.ServiceConfiguration configuration = this.getAsServiceConfiguration();
        return configuration.getFormat();
    }

    @Override
    public String getAsString() {
        Service.ServiceConfiguration configuration = this.getAsServiceConfiguration();
        return configuration.getValue();
    }

    @Override
    public <T> T getAsJson(Class<T> configType) {
        String configuration = this.getServiceConfigurationInFormat(Service.ServiceConfiguration.Format.JSON);
        return (T)JsonSerializer.json().fromJson(configuration, configType);
    }

    @Override
    public Properties getAsProperties() {
        String configuration = this.getServiceConfigurationInFormat(Service.ServiceConfiguration.Format.PROPERTIES);
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(configuration));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading properties configuration", e);
        }
        return properties;
    }

    private String getServiceConfigurationInFormat(Service.ServiceConfiguration.Format format) {
        Service.ServiceConfiguration configuration = this.getAsServiceConfiguration();
        Preconditions.checkArgument((configuration.getFormat() == format ? 1 : 0) != 0, (String)"Expected configuration in %s format, but actual was %s", (Object)format, (Object)configuration.getFormat());
        return configuration.getValue();
    }

    private Service.ServiceConfiguration getAsServiceConfiguration() {
        Service.ServiceConfiguration configuration = this.getAsMessage(Service.ServiceConfiguration.class);
        Preconditions.checkArgument((Service.ServiceConfiguration.Format.UNRECOGNIZED != configuration.getFormat() ? 1 : 0) != 0);
        return configuration;
    }

    public String toString() {
        return "ServiceConfiguration{" + Arrays.toString(this.configuration) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration that = (ServiceConfiguration)o;
        return Arrays.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Arrays.hashCode(this.configuration);
    }
}

