/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.ServiceWrapper;
import com.exonum.binding.core.transport.Server;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RuntimeTransport
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(RuntimeTransport.class);
    private final Server server;
    private final int port;

    @Inject
    public RuntimeTransport(Server server, @Named(value="Service web server port") int port) {
        this.server = (Server)Preconditions.checkNotNull((Object)server);
        this.port = port;
    }

    void start() {
        try {
            this.server.start(this.port).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    void connectServiceApi(ServiceWrapper service) {
        Router router = this.server.createRouter();
        service.createPublicApiHandlers(router);
        String serviceApiPath = RuntimeTransport.createServiceApiPath(service);
        this.server.mountSubRouter(serviceApiPath, router);
        this.logApiMountEvent(service, serviceApiPath, router);
    }

    void disconnectServiceApi(ServiceWrapper service) {
        String serviceApiPath = RuntimeTransport.createServiceApiPath(service);
        this.server.removeSubRouter(serviceApiPath);
        logger.info("Removed the service API endpoints at {}", (Object)serviceApiPath);
    }

    private static String createServiceApiPath(ServiceWrapper service) {
        String servicePathFragment = service.getPublicApiRelativePath();
        return "/api/services/" + servicePathFragment;
    }

    private void logApiMountEvent(ServiceWrapper service, String serviceApiPath, Router router) {
        List serviceRoutes = router.getRoutes();
        if (serviceRoutes.isEmpty()) {
            return;
        }
        String serviceName = service.getName();
        int port = this.server.getActualPort().orElse(0);
        logger.info("Service {} API is mounted at <host>::{}{}", (Object)serviceName, (Object)port, (Object)serviceApiPath);
        serviceRoutes.stream().map(Route::getPath).filter(Objects::nonNull).findAny().ifPresent(someRoute -> logger.info("    E.g.: http://127.0.0.1:{}{}", (Object)port, (Object)(serviceApiPath + someRoute)));
    }

    @Override
    public void close() throws InterruptedException {
        try {
            this.server.stop().get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }
}

