/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.proxy.AbstractCloseableNativeProxy;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.CloseFailuresException;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.binding.core.transaction.RawTransaction;
import com.exonum.binding.core.util.LibraryLoader;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NodeProxy
extends AbstractCloseableNativeProxy {
    private static final Logger logger;

    public NodeProxy(long nativeHandle) {
        super(nativeHandle, false);
    }

    public HashCode submitTransaction(RawTransaction rawTransaction) {
        byte[] payload = rawTransaction.getPayload();
        int serviceId = rawTransaction.getServiceId();
        int transactionId = rawTransaction.getTransactionId();
        byte[] txMessageHash = NodeProxy.nativeSubmit(this.getNativeHandle(), payload, serviceId, transactionId);
        return HashCode.fromBytes((byte[])txMessageHash);
    }

    private static native byte[] nativeSubmit(long var0, byte[] var2, int var3, int var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <ResultT> ResultT withSnapshot(Function<Snapshot, ResultT> snapshotFunction) {
        try (Cleaner cleaner = new Cleaner("NodeProxy#withSnapshot");){
            long nodeNativeHandle = this.getNativeHandle();
            long snapshotNativeHandle = this.nativeCreateSnapshot(nodeNativeHandle);
            Snapshot snapshot = Snapshot.newInstance(snapshotNativeHandle, cleaner);
            ResultT ResultT = snapshotFunction.apply(snapshot);
            return ResultT;
        }
        catch (CloseFailuresException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private native long nativeCreateSnapshot(long var1);

    public PublicKey getPublicKey() {
        byte[] publicKey = this.nativeGetPublicKey(this.getNativeHandle());
        return PublicKey.fromBytes((byte[])publicKey);
    }

    private native byte[] nativeGetPublicKey(long var1);

    @Override
    protected void disposeInternal() {
        NodeProxy.nativeFree(this.getNativeHandle());
    }

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
        logger = LogManager.getLogger(NodeProxy.class);
    }
}

