/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.AccessFactory;
import com.exonum.binding.core.runtime.AccessProxyFactory;
import com.exonum.binding.core.runtime.RuntimeModule;
import com.exonum.binding.core.transport.Server;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Map;

public final class FrameworkModule
extends AbstractModule {
    static final String SERVICE_RUNTIME_ARTIFACTS_DIRECTORY = "ServiceRuntime artifacts dir";
    static final String SERVICE_WEB_SERVER_PORT = "Service web server port";
    private final Path serviceArtifactsDir;
    private final int serviceWebServerPort;
    private final ImmutableMap<String, Class<?>> dependencyReferenceClasses;

    public FrameworkModule(Path serviceArtifactsDir, int serviceWebServerPort, Map<String, Class<?>> dependencyReferenceClasses) {
        this.serviceArtifactsDir = serviceArtifactsDir;
        this.serviceWebServerPort = serviceWebServerPort;
        this.dependencyReferenceClasses = ImmutableMap.copyOf(dependencyReferenceClasses);
    }

    protected void configure() {
        this.install((Module)new RuntimeModule((Map<String, Class<?>>)this.dependencyReferenceClasses));
        this.bind(Server.class).toProvider(Server::create).in(Singleton.class);
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)SERVICE_RUNTIME_ARTIFACTS_DIRECTORY)).toInstance((Object)this.serviceArtifactsDir);
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)SERVICE_WEB_SERVER_PORT)).toInstance((Object)this.serviceWebServerPort);
        this.bind(AccessFactory.class).toInstance((Object)AccessProxyFactory.getInstance());
    }
}

