/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.proxy;

import com.exonum.binding.core.proxy.AbstractNativeProxy;
import com.exonum.binding.core.proxy.CloseableNativeProxy;
import com.exonum.binding.core.proxy.NativeHandle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractCloseableNativeProxy
extends AbstractNativeProxy
implements CloseableNativeProxy {
    private final boolean dispose;
    private final Set<AbstractCloseableNativeProxy> referenced;

    protected AbstractCloseableNativeProxy(long nativeHandle, boolean dispose) {
        this(nativeHandle, dispose, Collections.emptySet());
    }

    protected AbstractCloseableNativeProxy(long nativeHandle, boolean dispose, AbstractCloseableNativeProxy referenced) {
        this(nativeHandle, dispose, Collections.singleton((AbstractCloseableNativeProxy)Preconditions.checkNotNull((Object)referenced)));
    }

    protected AbstractCloseableNativeProxy(long nativeHandle, boolean dispose, Collection<AbstractCloseableNativeProxy> referenced) {
        super(new NativeHandle(nativeHandle));
        this.dispose = dispose;
        this.referenced = this.getTransitivelyReferenced(referenced);
    }

    private Set<AbstractCloseableNativeProxy> getTransitivelyReferenced(Collection<AbstractCloseableNativeProxy> referenced) {
        return referenced.stream().flatMap(proxy -> Stream.concat(Stream.of(proxy), proxy.referenced.stream())).collect(Collectors.toSet());
    }

    @Override
    protected final long getNativeHandle() {
        this.checkAllRefsValid();
        return super.getNativeHandle();
    }

    @Override
    public final void close() {
        if (this.isValidHandle()) {
            try {
                this.checkAllRefsValid();
                if (this.dispose) {
                    this.disposeInternal();
                }
            }
            finally {
                this.invalidate();
            }
        }
    }

    private void checkAllRefsValid() {
        if (!this.allRefsValid()) {
            throw new IllegalStateException(this.getInvalidProxyErrMessage());
        }
    }

    private boolean allRefsValid() {
        return this.isValidHandle() && this.referenced.stream().allMatch(AbstractNativeProxy::isValidHandle);
    }

    private String getInvalidProxyErrMessage() {
        if (!this.isValidHandle()) {
            return String.format("This proxy (%s) is not valid", this);
        }
        Set<AbstractCloseableNativeProxy> invalidReferenced = this.getInvalidReferences();
        return String.format("This proxy (%s) references some invalid proxies: %s", this, invalidReferenced);
    }

    @VisibleForTesting
    Set<AbstractCloseableNativeProxy> getInvalidReferences() {
        return this.referenced.stream().filter(p -> !p.isValidHandle()).collect(Collectors.toSet());
    }

    protected abstract void disposeInternal();

    private void invalidate() {
        this.nativeHandle.close();
    }
}

