/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain.serialization;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.hash.Hashing;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.blockchain.Block;
import com.exonum.messages.core.Blockchain;
import com.exonum.messages.core.KeyValueSequenceOuterClass;
import com.exonum.messages.crypto.Types;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;

public enum BlockSerializer implements Serializer<Block>
{
    INSTANCE;

    private static final Serializer<Blockchain.Block> PROTO_SERIALIZER;

    public byte[] toBytes(Block value) {
        Blockchain.Block block = Blockchain.Block.newBuilder().setProposerId(value.getProposerId()).setHeight(value.getHeight()).setTxCount(value.getNumTransactions()).setPrevHash(BlockSerializer.toHashProto(value.getPreviousBlockHash())).setTxHash(BlockSerializer.toHashProto(value.getTxRootHash())).setStateHash(BlockSerializer.toHashProto(value.getStateHash())).setErrorHash(BlockSerializer.toHashProto(value.getErrorHash())).setAdditionalHeaders(BlockSerializer.toHeadersProto(value.getAdditionalHeaders())).build();
        return block.toByteArray();
    }

    public Block fromBytes(byte[] binaryBlock) {
        Blockchain.Block blockMessage = (Blockchain.Block)PROTO_SERIALIZER.fromBytes(binaryBlock);
        HashCode blockHash = Hashing.sha256().hashBytes(binaryBlock);
        return BlockSerializer.newBlockInternal(blockMessage, blockHash);
    }

    public static Block newBlockInternal(Blockchain.Block blockMessage, HashCode blockHash) {
        return Block.builder().proposerId(blockMessage.getProposerId()).height(blockMessage.getHeight()).numTransactions(blockMessage.getTxCount()).blockHash(blockHash).previousBlockHash(BlockSerializer.toHashCode(blockMessage.getPrevHash())).txRootHash(BlockSerializer.toHashCode(blockMessage.getTxHash())).stateHash(BlockSerializer.toHashCode(blockMessage.getStateHash())).errorHash(BlockSerializer.toHashCode(blockMessage.getErrorHash())).additionalHeaders(BlockSerializer.toHeadersMap(blockMessage.getAdditionalHeaders())).build();
    }

    private static Types.Hash toHashProto(HashCode hash) {
        ByteString bytes = ByteString.copyFrom((byte[])hash.asBytes());
        return Types.Hash.newBuilder().setData(bytes).build();
    }

    private static HashCode toHashCode(Types.Hash hash) {
        ByteString bytes = hash.getData();
        return HashCode.fromBytes((byte[])bytes.toByteArray());
    }

    @VisibleForTesting
    static ImmutableMap<String, ByteString> toHeadersMap(Blockchain.AdditionalHeaders headers) {
        return (ImmutableMap)headers.getHeaders().getEntriesList().stream().collect(ImmutableMap.toImmutableMap(KeyValueSequenceOuterClass.KeyValue::getKey, KeyValueSequenceOuterClass.KeyValue::getValue));
    }

    @VisibleForTesting
    static Blockchain.AdditionalHeaders toHeadersProto(ImmutableMap<String, ByteString> headers) {
        KeyValueSequenceOuterClass.KeyValueSequence.Builder additionalHeadersBuilder = KeyValueSequenceOuterClass.KeyValueSequence.newBuilder();
        headers.forEach((k, v) -> additionalHeadersBuilder.addEntries(BlockSerializer.toProtoEntry(k, v)));
        return Blockchain.AdditionalHeaders.newBuilder().setHeaders(additionalHeadersBuilder.build()).build();
    }

    private static KeyValueSequenceOuterClass.KeyValue toProtoEntry(String key, ByteString value) {
        return KeyValueSequenceOuterClass.KeyValue.newBuilder().setKey(key).setValue(value).build();
    }

    static {
        PROTO_SERIALIZER = StandardSerializers.protobuf(Blockchain.Block.class);
    }
}

