/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain;

import com.exonum.binding.common.blockchain.TransactionLocation;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.message.TransactionMessage;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.blockchain.Block;
import com.exonum.binding.core.blockchain.serialization.BlockSerializer;
import com.exonum.binding.core.blockchain.serialization.TransactionLocationSerializer;
import com.exonum.binding.core.storage.database.Access;
import com.exonum.binding.core.storage.indices.EntryIndex;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.KeySetIndexProxy;
import com.exonum.binding.core.storage.indices.ListIndex;
import com.exonum.binding.core.storage.indices.MapIndex;
import com.exonum.binding.core.storage.indices.MapIndexProxy;
import com.exonum.binding.core.storage.indices.ProofEntryIndex;
import com.exonum.binding.core.storage.indices.ProofListIndexProxy;
import com.exonum.binding.core.storage.indices.ProofMapIndexProxy;
import com.exonum.messages.core.Blockchain;
import com.exonum.messages.core.runtime.Errors;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class CoreSchema {
    private final Access dbAccess;
    private static final Serializer<Block> BLOCK_SERIALIZER = BlockSerializer.INSTANCE;
    private static final Serializer<TransactionLocation> TRANSACTION_LOCATION_SERIALIZER = TransactionLocationSerializer.INSTANCE;
    private static final Serializer<Errors.ExecutionError> EXECUTION_ERROR_SERIALIZER = StandardSerializers.protobuf(Errors.ExecutionError.class);
    private static final Serializer<Errors.ExecutionErrorAux> EXECUTION_ERROR_AUX_SERIALIZER = StandardSerializers.protobuf(Errors.ExecutionErrorAux.class);
    private static final Serializer<Blockchain.CallInBlock> CALL_IN_BLOCK_SERIALIZER = StandardSerializers.protobuf(Blockchain.CallInBlock.class);
    private static final Serializer<TransactionMessage> TRANSACTION_MESSAGE_SERIALIZER = StandardSerializers.transactionMessage();
    private static final Serializer<Blockchain.Config> CONSENSUS_CONFIG_SERIALIZER = StandardSerializers.protobuf(Blockchain.Config.class);

    private CoreSchema(Access dbAccess) {
        this.dbAccess = dbAccess;
    }

    static CoreSchema newInstance(Access dbAccess) {
        return new CoreSchema(dbAccess);
    }

    long getHeight() {
        ListIndex<HashCode> blockHashes = this.getBlockHashes();
        Preconditions.checkState((!blockHashes.isEmpty() ? 1 : 0) != 0, (Object)"No genesis block created yet (block hashes list is empty)");
        return blockHashes.size() - 1L;
    }

    ListIndex<HashCode> getBlockHashes() {
        return this.dbAccess.getList(CoreIndex.ALL_BLOCK_HASHES, StandardSerializers.hash());
    }

    ProofListIndexProxy<HashCode> getBlockTransactions(long blockHeight) {
        this.checkBlockHeight(blockHeight);
        byte[] id = this.toCoreStorageKey(blockHeight);
        IndexAddress address = IndexAddress.valueOf("core.block_transactions", id);
        return this.dbAccess.getProofList(address, StandardSerializers.hash());
    }

    MapIndex<HashCode, Block> getBlocks() {
        return this.dbAccess.getMap(CoreIndex.BLOCKS, StandardSerializers.hash(), BLOCK_SERIALIZER);
    }

    MapIndex<HashCode, TransactionMessage> getTxMessages() {
        return this.dbAccess.getMap(CoreIndex.TRANSACTIONS, StandardSerializers.hash(), TRANSACTION_MESSAGE_SERIALIZER);
    }

    ProofMapIndexProxy<Blockchain.CallInBlock, Errors.ExecutionError> getCallErrors(long blockHeight) {
        this.checkBlockHeight(blockHeight);
        byte[] idInGroup = this.toCoreStorageKey(blockHeight);
        IndexAddress address = IndexAddress.valueOf("core.call_errors", idInGroup);
        return this.dbAccess.getProofMap(address, CALL_IN_BLOCK_SERIALIZER, EXECUTION_ERROR_SERIALIZER);
    }

    MapIndexProxy<Blockchain.CallInBlock, Errors.ExecutionErrorAux> getCallErrorsAux(long blockHeight) {
        this.checkBlockHeight(blockHeight);
        byte[] idInGroup = this.toCoreStorageKey(blockHeight);
        IndexAddress address = IndexAddress.valueOf("core.call_errors_aux", idInGroup);
        return this.dbAccess.getMap(address, CALL_IN_BLOCK_SERIALIZER, EXECUTION_ERROR_AUX_SERIALIZER);
    }

    MapIndex<HashCode, TransactionLocation> getTxLocations() {
        return this.dbAccess.getMap(CoreIndex.TRANSACTIONS_LOCATIONS, StandardSerializers.hash(), TRANSACTION_LOCATION_SERIALIZER);
    }

    KeySetIndexProxy<HashCode> getTransactionPool() {
        return this.dbAccess.getKeySet(CoreIndex.TRANSACTIONS_POOL, StandardSerializers.hash());
    }

    Blockchain.Config getConsensusConfiguration() {
        ProofEntryIndex<Blockchain.Config> configEntry = this.dbAccess.getProofEntry(CoreIndex.CONSENSUS_CONFIG, CONSENSUS_CONFIG_SERIALIZER);
        Preconditions.checkState((boolean)configEntry.isPresent(), (Object)"No consensus configuration: requesting the configuration before the genesis block was created");
        return (Blockchain.Config)configEntry.get();
    }

    EntryIndex<Long> getNumTransactions() {
        Serializer serializer = StandardSerializers.fixed64();
        return this.dbAccess.getEntry(CoreIndex.NUM_TRANSACTIONS, serializer);
    }

    private void checkBlockHeight(long blockHeight) {
        Preconditions.checkArgument((blockHeight >= 0L ? 1 : 0) != 0, (String)"Height shouldn't be negative, but was %s", (long)blockHeight);
        long blockchainHeight = this.getHeight();
        Preconditions.checkArgument((blockchainHeight >= blockHeight ? 1 : 0) != 0, (String)"Height should be less than or equal to the blockchain height %s, but was %s", (long)blockchainHeight, (long)blockHeight);
    }

    private byte[] toCoreStorageKey(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(value).array();
    }

    private static final class CoreIndex {
        private static final String PREFIX = "core.";
        private static final String BLOCK_TRANSACTIONS = "core.block_transactions";
        private static final IndexAddress ALL_BLOCK_HASHES = IndexAddress.valueOf("core.block_hashes_by_height");
        private static final IndexAddress TRANSACTIONS = IndexAddress.valueOf("core.transactions");
        private static final IndexAddress BLOCKS = IndexAddress.valueOf("core.blocks");
        private static final String CALL_ERRORS = "core.call_errors";
        private static final String CALL_ERRORS_AUX = "core.call_errors_aux";
        private static final IndexAddress TRANSACTIONS_LOCATIONS = IndexAddress.valueOf("core.transactions_locations");
        private static final IndexAddress TRANSACTIONS_POOL = IndexAddress.valueOf("core.transactions_pool");
        private static final IndexAddress CONSENSUS_CONFIG = IndexAddress.valueOf("core.consensus_config");
        private static final IndexAddress NUM_TRANSACTIONS = IndexAddress.valueOf("core.transactions_len");

        private CoreIndex() {
        }
    }
}

